package ru.yandex.direct.core.entity.campaign.repository;

import java.time.LocalDateTime;
import java.util.Collection;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.InsertValuesStep2;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import ru.yandex.direct.dbschema.ppc.tables.records.CampActivizationRecord;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;

import static ru.yandex.direct.dbschema.ppc.Tables.CAMP_ACTIVIZATION;

@Repository
@ParametersAreNonnullByDefault
public class CampActivizationRepository {

    private final DslContextProvider dslContextProvider;

    @Autowired
    public CampActivizationRepository(DslContextProvider dslContextProvider) {
        this.dslContextProvider = dslContextProvider;
    }

    /**
     * Добавить в таблицу ppc.camp_activization заданные id кампаний
     * id кампаний, которые уже есть в таблице, игнорируются.
     *
     * @param shard       Номер shard-а
     * @param campaignIds Список id кампаний
     */
    public void addCampsForActivization(int shard, Collection<Long> campaignIds) {
        addCampsForActivization(shard, campaignIds, LocalDateTime.now());
    }

    /**
     * Метод нужен для тестов - для проставления sendTime
     * Добавить в таблицу ppc.camp_activization заданные id кампаний
     * id кампаний, которые уже есть в таблице, игнорируются.
     *
     * @param shard       Номер shard-а
     * @param campaignIds Список id кампаний
     */
    void addCampsForActivization(int shard, Collection<Long> campaignIds, LocalDateTime sendTime) {
        if (campaignIds.isEmpty()) {
            return;
        }

        InsertValuesStep2<CampActivizationRecord, Long, LocalDateTime> batch = dslContextProvider.ppc(shard)
                .insertInto(CAMP_ACTIVIZATION,
                        CAMP_ACTIVIZATION.CID, CAMP_ACTIVIZATION.SEND_TIME);
        campaignIds.forEach(cid -> batch.values(cid, sendTime));

        batch.onDuplicateKeyIgnore()
                .execute();
    }
}
