package ru.yandex.direct.core.entity.campaign.repository;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import ru.yandex.direct.core.entity.campaign.model.CampAdditionalData;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.jooqmapper.JooqMapperWithSupplier;
import ru.yandex.direct.jooqmapper.JooqMapperWithSupplierBuilder;

import static ru.yandex.direct.dbschema.ppc.Tables.CAMPAIGNS;
import static ru.yandex.direct.dbschema.ppc.Tables.CAMP_ADDITIONAL_DATA;
import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.property;

@Repository
@ParametersAreNonnullByDefault
public class CampAdditionalDataRepository {
    private final DslContextProvider dslContextProvider;

    private static final JooqMapperWithSupplier<CampAdditionalData> CAMP_ADDITIONAL_DATA_MAPPER =
            createMapper();

    @Autowired
    public CampAdditionalDataRepository(DslContextProvider dslContextProvider) {
        this.dslContextProvider = dslContextProvider;
    }

    public List<CampAdditionalData> getByClientId(int shard, ClientId clientId) {
        return dslContextProvider.ppc(shard)
                .select(CAMP_ADDITIONAL_DATA_MAPPER.getFieldsToRead())
                .from(CAMPAIGNS.join(CAMP_ADDITIONAL_DATA).on(CAMPAIGNS.CID.eq(CAMP_ADDITIONAL_DATA.CID)))
                .where(CAMPAIGNS.CLIENT_ID.eq(clientId.asLong()))
                .fetch(CAMP_ADDITIONAL_DATA_MAPPER::fromDb);
    }

    private static JooqMapperWithSupplier<CampAdditionalData> createMapper() {
        return JooqMapperWithSupplierBuilder.builder(CampAdditionalData::new)
                .map(property(CampAdditionalData.CID, CAMP_ADDITIONAL_DATA.CID))
                .map(property(CampAdditionalData.HREF, CAMP_ADDITIONAL_DATA.HREF))
                .map(property(CampAdditionalData.COMPANY_NAME, CAMP_ADDITIONAL_DATA.COMPANY_NAME))
                .map(property(CampAdditionalData.BUSINESS_CATEGORY, CAMP_ADDITIONAL_DATA.BUSINESS_CATEGORY))
                .build();
    }
}
