package ru.yandex.direct.core.entity.campaign.repository;

import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.function.Supplier;

import javax.annotation.ParametersAreNonnullByDefault;

import com.google.common.collect.ImmutableBiMap;
import one.util.streamex.EntryStream;

import ru.yandex.direct.core.entity.campaign.model.BaseCampaign;
import ru.yandex.direct.core.entity.campaign.model.BillingAggregateCampaign;
import ru.yandex.direct.core.entity.campaign.model.CampaignType;
import ru.yandex.direct.core.entity.campaign.model.ContentPromotionCampaign;
import ru.yandex.direct.core.entity.campaign.model.CpmBannerCampaign;
import ru.yandex.direct.core.entity.campaign.model.CpmDealsCampaign;
import ru.yandex.direct.core.entity.campaign.model.CpmPriceCampaign;
import ru.yandex.direct.core.entity.campaign.model.CpmYndxFrontpageCampaign;
import ru.yandex.direct.core.entity.campaign.model.DynamicCampaign;
import ru.yandex.direct.core.entity.campaign.model.GeoCampaign;
import ru.yandex.direct.core.entity.campaign.model.InternalAutobudgetCampaign;
import ru.yandex.direct.core.entity.campaign.model.InternalDistribCampaign;
import ru.yandex.direct.core.entity.campaign.model.InternalFreeCampaign;
import ru.yandex.direct.core.entity.campaign.model.McBannerCampaign;
import ru.yandex.direct.core.entity.campaign.model.MobileContentCampaign;
import ru.yandex.direct.core.entity.campaign.model.SmartCampaign;
import ru.yandex.direct.core.entity.campaign.model.TextCampaign;
import ru.yandex.direct.core.entity.campaign.model.WalletTypedCampaign;
import ru.yandex.direct.dbschema.ppc.enums.CampaignsType;

@ParametersAreNonnullByDefault
public class CampaignRepositoryConstants {

    public static final ImmutableBiMap<Class<? extends BaseCampaign>, CampaignType> CAMPAIGN_CLASS_TO_TYPE =
            new ImmutableBiMap.Builder<Class<? extends BaseCampaign>, CampaignType>()
                    .put(TextCampaign.class, CampaignType.TEXT) // CampaignsType ? use fromSource toSource
                    .put(SmartCampaign.class, CampaignType.PERFORMANCE)
                    .put(ContentPromotionCampaign.class, CampaignType.CONTENT_PROMOTION)
                    .put(CpmPriceCampaign.class, CampaignType.CPM_PRICE)
                    .put(InternalAutobudgetCampaign.class, CampaignType.INTERNAL_AUTOBUDGET)
                    .put(WalletTypedCampaign.class, CampaignType.WALLET)
                    .put(CpmBannerCampaign.class, CampaignType.CPM_BANNER)
                    .put(CpmYndxFrontpageCampaign.class, CampaignType.CPM_YNDX_FRONTPAGE)
                    .put(DynamicCampaign.class, CampaignType.DYNAMIC)
                    .put(BillingAggregateCampaign.class, CampaignType.BILLING_AGGREGATE)
                    .put(McBannerCampaign.class, CampaignType.MCBANNER)
                    .put(MobileContentCampaign.class, CampaignType.MOBILE_CONTENT)
                    .put(CpmDealsCampaign.class, CampaignType.CPM_DEALS)
                    .put(InternalDistribCampaign.class, CampaignType.INTERNAL_DISTRIB)
                    .put(InternalFreeCampaign.class, CampaignType.INTERNAL_FREE)
                    .put(GeoCampaign.class, CampaignType.GEO)
                    .build();

    public static final Map<Class<? extends BaseCampaign>, CampaignsType> CAMPAIGN_CLASS_TO_JOOQ_TYPE =
            EntryStream.of(CAMPAIGN_CLASS_TO_TYPE)
                    .mapValues(CampaignType::toSource)
                    .toMap();

    public static final ImmutableBiMap<CampaignType, Class<? extends BaseCampaign>> CAMPAIGN_TYPE_TO_CLASS =
            CAMPAIGN_CLASS_TO_TYPE.inverse();

    public static final Map<CampaignType, Supplier<BaseCampaign>> TYPE_TO_CAMPAIGN_CLASS_SUPPLIER =
            EntryStream.of(CAMPAIGN_TYPE_TO_CLASS)
                    .mapValues(x -> (Supplier<BaseCampaign>) () -> {
                        try {
                            return x.getDeclaredConstructor().newInstance();
                        } catch (InstantiationException | IllegalAccessException | InvocationTargetException
                                | NoSuchMethodException e) {
                            throw new RuntimeException(e);
                        }
                    })
                    .toImmutableMap();

}
