package ru.yandex.direct.core.entity.campaign.repository.filter;

import java.util.Collection;
import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.campaign.model.CampaignType;
import ru.yandex.direct.dbschema.ppc.enums.CampaignsArchived;
import ru.yandex.direct.dbschema.ppc.enums.CampaignsCpmPriceStatusApprove;
import ru.yandex.direct.dbschema.ppc.enums.CampaignsStatusempty;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.multitype.repository.filter.ConditionFilter;
import ru.yandex.direct.multitype.repository.filter.Filter;

import static ru.yandex.direct.dbschema.ppc.Tables.CAMPAIGNS;
import static ru.yandex.direct.dbschema.ppc.Tables.CAMPAIGNS_CPM_PRICE;
import static ru.yandex.direct.multitype.repository.filter.ConditionFilterFactory.multipleConditionFilter;
import static ru.yandex.direct.multitype.repository.filter.ConditionFilterFactory.whereEqFilter;
import static ru.yandex.direct.multitype.repository.filter.ConditionFilterFactory.whereInFilter;
import static ru.yandex.direct.multitype.repository.filter.ConditionFilterFactory.whereNotInFilter;
import static ru.yandex.direct.utils.FunctionalUtils.mapList;

@ParametersAreNonnullByDefault
public class CampaignFilterFactory {
    private CampaignFilterFactory() {
    }

    public static ConditionFilter campaignIdsFilter(Collection<Long> campaignIds) {
        return whereInFilter(CAMPAIGNS.CID, campaignIds);
    }

    public static Filter campaignTypesFilter(ClientId clientId, Collection<CampaignType> campaignTypes) {
        return multipleConditionFilter(campaignClientIdFilter(clientId), campaignTypesFilter(campaignTypes));
    }

    public static ConditionFilter campaignClientIdFilter(ClientId clientId) {
        return whereEqFilter(CAMPAIGNS.CLIENT_ID, clientId.asLong());
    }

    public static ConditionFilter campaignTypesFilter(Collection<CampaignType> campaignTypes) {
        var types = mapList(campaignTypes, CampaignType::toSource);
        return whereInFilter(CAMPAIGNS.TYPE, types);
    }

    public static ConditionFilter campaignClientIdsFilter(Collection<ClientId> clientIds) {
        List<Long> ids = mapList(clientIds, ClientId::asLong);
        return whereInFilter(CAMPAIGNS.CLIENT_ID, ids);
    }

    public static ConditionFilter campaignTypesExceptFilter(Collection<CampaignType> campaignTypesExcept) {
        var types = mapList(campaignTypesExcept, CampaignType::toSource);
        return whereNotInFilter(CAMPAIGNS.TYPE, types);
    }

    public static ConditionFilter campaignIsNotEmpty() {
        return whereEqFilter(CAMPAIGNS.STATUS_EMPTY, CampaignsStatusempty.No);
    }

    public static ConditionFilter campaignIsNotArchived() {
        return whereEqFilter(CAMPAIGNS.ARCHIVED, CampaignsArchived.No);
    }

    public static ConditionFilter cpmPriceCampaignStatusApproveIs(CampaignsCpmPriceStatusApprove statusApprove) {
        return whereEqFilter(CAMPAIGNS_CPM_PRICE.STATUS_APPROVE, statusApprove);
    }

    public static Filter campaignIsNotArchivedTypesFilter(ClientId clientId, Collection<CampaignType> campaignTypes) {
        var types = mapList(campaignTypes, CampaignType::toSource);
        return multipleConditionFilter(
                whereEqFilter(CAMPAIGNS.CLIENT_ID, clientId.asLong()),
                whereInFilter(CAMPAIGNS.TYPE, types),
                campaignIsNotArchived());
    }

}
