package ru.yandex.direct.core.entity.campaign.repository.type;

import java.util.Collection;
import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.Record;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithAdditionalData;
import ru.yandex.direct.core.entity.campaign.service.type.add.container.RestrictedCampaignsAddOperationContainer;
import ru.yandex.direct.core.entity.campaign.service.type.update.container.RestrictedCampaignsUpdateOperationContainer;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.jooqmapper.JooqMapper;
import ru.yandex.direct.jooqmapperhelper.InsertHelperAggregator;
import ru.yandex.direct.jooqmapperhelper.UpdateHelperAggregator;
import ru.yandex.direct.model.AppliedChanges;

import static ru.yandex.direct.dbschema.ppc.Tables.CAMP_ADDITIONAL_DATA;
import static ru.yandex.direct.utils.FunctionalUtils.filterList;

@ParametersAreNonnullByDefault
public abstract class AbstractCampaignWithAdditionalDataRepositorySupport<T extends CampaignWithAdditionalData>
        extends AbstractCampaignRepositoryTypeSupport<T> {
    public AbstractCampaignWithAdditionalDataRepositorySupport(DslContextProvider dslContextProvider) {
        super(dslContextProvider);
    }

    @Override
    public <M extends T> void fillFromRecord(M model, Record record) {
        getCampAdditionalDataTableMapper().fromDb(record, model);
    }

    @Override
    public void updateAdditionTables(DSLContext context, RestrictedCampaignsUpdateOperationContainer updateParameters,
                                     Collection<AppliedChanges<T>> appliedChanges) {
    }

    @Override
    public void insertToAdditionTables(DSLContext context,
                                       RestrictedCampaignsAddOperationContainer addModelParametersContainer,
                                       Collection<T> models) {
    }

    @Override
    public Collection<Field<?>> getFields() {
        return getCampAdditionalDataTableMapper().getFieldsToRead();
    }

    @Override
    public void processUpdate(UpdateHelperAggregator updateHelperAggregator,
                              Collection<AppliedChanges<T>> appliedChanges) {
        List<AppliedChanges<T>> changedCampaigns = filterList(appliedChanges, t -> isCampAdditionalDataChanged(t));
        updateHelperAggregator.getOrCreate(CAMP_ADDITIONAL_DATA.CID)
                .processUpdateAll(getCampAdditionalDataTableMapper(), changedCampaigns);
    }

    @Override
    public void pushToInsert(InsertHelperAggregator insertHelperAggregator, T campaign) {
        if (isCampAdditionalDataAdded(campaign)) {
            insertHelperAggregator.getOrCreate(CAMP_ADDITIONAL_DATA).add(getCampAdditionalDataTableMapper(), campaign);
        }
    }

    protected abstract boolean isCampAdditionalDataAdded(T campaign);

    protected abstract boolean isCampAdditionalDataChanged(AppliedChanges<T> appliedChangesItem);

    protected abstract boolean isCampAdditionalDataChangedAndDeleted(AppliedChanges<T> appliedChangesItem);

    protected abstract boolean wasNotPresentBefore(AppliedChanges<T> appliedChangesItem);

    protected boolean isMissingAfter(AppliedChanges<T> appliedChangesItem) {
        return isCampAdditionalDataChangedAndDeleted(appliedChangesItem) ||
                (wasNotPresentBefore(appliedChangesItem) && !isCampAdditionalDataChanged(appliedChangesItem));
    }

    protected boolean isCampAdditionalDataAdded(AppliedChanges<T> appliedChangesItem) {
        return wasNotPresentBefore(appliedChangesItem) && isCampAdditionalDataAdded(appliedChangesItem.getModel());
    }

    protected abstract JooqMapper<T> getCampAdditionalDataTableMapper();
}
