package ru.yandex.direct.core.entity.campaign.repository.type

import org.jooq.Record
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component
import ru.yandex.direct.core.entity.campaign.model.BaseCampaign
import ru.yandex.direct.core.entity.campaign.model.CampaignWithAddMetrikaTagToUrl
import ru.yandex.direct.core.entity.campaign.model.CampaignWithBrandLift
import ru.yandex.direct.core.entity.campaign.model.CampaignWithBroadMatch
import ru.yandex.direct.core.entity.campaign.model.CampaignWithCheckPositionEvent
import ru.yandex.direct.core.entity.campaign.model.CampaignWithDayBudget
import ru.yandex.direct.core.entity.campaign.model.CampaignWithExcludePausedCompetingAds
import ru.yandex.direct.core.entity.campaign.model.CampaignWithImpressionRate
import ru.yandex.direct.core.entity.campaign.model.CampaignWithNetworkSettings
import ru.yandex.direct.core.entity.campaign.model.CampaignWithOptionalAddMetrikaTagToUrl
import ru.yandex.direct.core.entity.campaign.model.CampaignWithOptionalAddOpenstatTagToUrl
import ru.yandex.direct.core.entity.campaign.model.CampaignWithPlacementTypes
import ru.yandex.direct.core.entity.campaign.model.CampaignWithSiteMonitoring
import ru.yandex.direct.currency.Money
import ru.yandex.direct.dbschema.ppc.Tables
import ru.yandex.direct.dbschema.ppc.enums.CampOptionsBroadMatchFlag
import ru.yandex.direct.dbschema.ppc.enums.CampOptionsFairauction
import ru.yandex.direct.dbschema.ppc.enums.CampOptionsSendwarn
import ru.yandex.direct.dbschema.ppc.enums.CampOptionsStatusmetricacontrol
import ru.yandex.direct.dbschema.ppc.enums.CampOptionsWarnplaceinterval
import ru.yandex.direct.dbschema.ppc.enums.CampaignsDayBudgetShowMode
import ru.yandex.direct.dbschema.ppc.enums.CampaignsStatusopenstat
import ru.yandex.direct.dbutil.wrapper.DslContextProvider
import ru.yandex.direct.jooqmapperhelper.InsertHelperAggregator
import java.math.BigDecimal
import java.math.RoundingMode
import javax.annotation.ParametersAreNonnullByDefault

@Component
@ParametersAreNonnullByDefault
class BaseCampaignRepositoryTypeSupport @Autowired constructor(dslContextProvider: DslContextProvider) :
        AbstractCampaignRepositoryTypeSupport<BaseCampaign>(dslContextProvider) {

    override fun getFields() = listOf(Tables.CAMPAIGNS.CID)

    override fun <M : BaseCampaign?> fillFromRecord(model: M, record: Record) {
        model!!.id = record.get(Tables.CAMPAIGNS.CID)
    }

    override fun getTypeClass() = BaseCampaign::class.java

    override fun pushToInsert(insertHelperAggregator: InsertHelperAggregator, model: BaseCampaign) {
        //при добавлении двух кампаний разных типов, например TextCampaign и DynamicCampaign
        //возникает ошибка при записи в таблицу campaigns вида "Column 'rfReset' cannot be null"
        //т.к. DynamicCampaign не наследует интерфейс CampaignWithImpressionRate, то при построении insert-а
        //записывается null в not null поле.
        //Чтобы избежать таких ошибок добавляем дефолтные значения всем кампаниям, у которых нет таких полей
        insertCampaignsTableDefaultValues(insertHelperAggregator, model)
        insertCampOptionsTableDefaultValues(insertHelperAggregator, model)
    }

    private fun insertCampaignsTableDefaultValues(insertHelperAggregator: InsertHelperAggregator, model: BaseCampaign) {
        val insertHelper = insertHelperAggregator.getOrCreate(Tables.CAMPAIGNS)
        insertHelper.set(Tables.CAMPAIGNS.CID, model.id)
        if (model !is CampaignWithImpressionRate) {
            insertHelper.set(Tables.CAMPAIGNS.RF_RESET, 0L)
            insertHelper.set(Tables.CAMPAIGNS.RF, 0L)
        }
        if (model !is CampaignWithNetworkSettings) {
            insertHelper.set(Tables.CAMPAIGNS.CONTEXT_LIMIT, 0L)
            insertHelper.set(Tables.CAMPAIGNS.CONTEXT_PRICE_COEF, 100L)
        }
        if (model !is CampaignWithDayBudget) {
            insertHelper.set(Tables.CAMPAIGNS.DAY_BUDGET,
                    BigDecimal.ZERO.setScale(Money.MONEY_CENT_SCALE, RoundingMode.HALF_UP))
            insertHelper.set(Tables.CAMPAIGNS.DAY_BUDGET_SHOW_MODE, CampaignsDayBudgetShowMode.default_)
        }
        if (model !is CampaignWithOptionalAddOpenstatTagToUrl) {
            insertHelper.set(Tables.CAMPAIGNS.STATUS_OPEN_STAT, CampaignsStatusopenstat.No)
        }
    }

    private fun insertCampOptionsTableDefaultValues(insertHelperAggregator: InsertHelperAggregator,
                                                    model: BaseCampaign) {
        val insertHelper = insertHelperAggregator.getOrCreate(Tables.CAMP_OPTIONS)
        insertHelper.set(Tables.CAMP_OPTIONS.CID, model.id)
        if (model !is CampaignWithBroadMatch) {
            insertHelper.set(Tables.CAMP_OPTIONS.BROAD_MATCH_FLAG, CampOptionsBroadMatchFlag.No)
            insertHelper.set(Tables.CAMP_OPTIONS.BROAD_MATCH_LIMIT, 0L)
        }
        if (model !is CampaignWithExcludePausedCompetingAds) {
            insertHelper.set(Tables.CAMP_OPTIONS.FAIR_AUCTION, CampOptionsFairauction.No)
        }
        if (model !is CampaignWithDayBudget) {
            insertHelper.set(Tables.CAMP_OPTIONS.DAY_BUDGET_DAILY_CHANGE_COUNT, 0L)
        }
        if (model !is CampaignWithSiteMonitoring) {
            insertHelper.set(Tables.CAMP_OPTIONS.STATUS_METRICA_CONTROL, CampOptionsStatusmetricacontrol.No)
        }
        if (model !is CampaignWithOptionalAddMetrikaTagToUrl
                && model !is CampaignWithAddMetrikaTagToUrl) {
            insertHelper.set(Tables.CAMP_OPTIONS.STATUS_CLICK_TRACK, 0L)
        }
        if (model !is CampaignWithBrandLift) {
            insertHelper.set(Tables.CAMP_OPTIONS.IS_CPM_GLOBAL_AB_SEGMENT, 0L)
            insertHelper.set(Tables.CAMP_OPTIONS.IS_SEARCH_LIFT_ENABLED, 0L)
        }
        if (model !is CampaignWithPlacementTypes) {
            insertHelper.set(Tables.CAMP_OPTIONS.PLACEMENT_TYPES, "")
        }
        if (model !is CampaignWithCheckPositionEvent) {
            insertHelper.set(Tables.CAMP_OPTIONS.WARN_PLACE_INTERVAL, CampOptionsWarnplaceinterval._60)
            insertHelper.set(Tables.CAMP_OPTIONS.SEND_WARN, CampOptionsSendwarn.Yes)
        }
    }

}
