package ru.yandex.direct.core.entity.campaign.repository.type;

import java.util.Collection;
import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import one.util.streamex.EntryStream;
import org.jetbrains.annotations.Nullable;
import org.jooq.Condition;
import org.jooq.Record;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.BaseCampaign;
import ru.yandex.direct.core.entity.campaign.model.CampaignType;
import ru.yandex.direct.core.entity.campaign.service.type.add.container.RestrictedCampaignsAddOperationContainer;
import ru.yandex.direct.core.entity.campaign.service.type.update.container.RestrictedCampaignsUpdateOperationContainer;
import ru.yandex.direct.dbschema.ppc.enums.CampaignsType;
import ru.yandex.direct.multitype.repository.RepositoryTypeSupportFacade;

import static java.util.Collections.singleton;
import static ru.yandex.direct.core.entity.campaign.repository.CampaignRepositoryConstants.CAMPAIGN_CLASS_TO_JOOQ_TYPE;
import static ru.yandex.direct.core.entity.campaign.repository.CampaignRepositoryConstants.TYPE_TO_CAMPAIGN_CLASS_SUPPLIER;
import static ru.yandex.direct.core.entity.campaign.service.CampaignUpdateOperationConstants.CAMPAIGN_TYPE_SUPPORT_CLASS_WHITE_LIST;
import static ru.yandex.direct.dbschema.ppc.Tables.CAMPAIGNS;

@Component
@ParametersAreNonnullByDefault
public class CampaignRepositoryTypeSupportFacade extends RepositoryTypeSupportFacade<BaseCampaign, CampaignType,
        RestrictedCampaignsAddOperationContainer, RestrictedCampaignsUpdateOperationContainer> {

    @Autowired
    public CampaignRepositoryTypeSupportFacade(
            List<CampaignRepositoryTypeSupport<? extends BaseCampaign>> typeSupports) {
        super(typeSupports, TYPE_TO_CAMPAIGN_CLASS_SUPPLIER, singleton(CAMPAIGNS.TYPE),
                CAMPAIGN_TYPE_SUPPORT_CLASS_WHITE_LIST);
    }

    @Override
    protected CampaignType getModelType(Record record) {
        return CampaignType.fromSource(record.get(CAMPAIGNS.TYPE, CampaignsType.class));
    }

    @Nullable
    @Override
    protected Condition getConditionThatRecordAnyOfClasses(Collection<Class<? extends BaseCampaign>> classes) {
        List<CampaignsType> types = EntryStream.of(CAMPAIGN_CLASS_TO_JOOQ_TYPE)
                .filterKeys(runtimeClass -> classes.stream().anyMatch(c -> c.isAssignableFrom(runtimeClass)))
                .values()
                .toList();
        return (types.size() == CAMPAIGN_CLASS_TO_JOOQ_TYPE.size()) ? null : CAMPAIGNS.TYPE.in(types);
    }

}

