package ru.yandex.direct.core.entity.campaign.repository.type;

import java.util.Collection;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.Field;
import org.jooq.Record;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.converter.CampaignConverter;
import ru.yandex.direct.core.entity.campaign.model.CampaignSupportedOnTouch;
import ru.yandex.direct.core.entity.campaign.model.CommonCampaign;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.jooqmapper.read.JooqReader;
import ru.yandex.direct.jooqmapper.read.JooqReaderBuilder;

import static ru.yandex.direct.dbschema.ppc.tables.Campaigns.CAMPAIGNS;
import static ru.yandex.direct.jooqmapper.read.ReaderBuilders.fromField;

@Component
@ParametersAreNonnullByDefault
public class CampaignSupportedOnTouchTypeSupport extends
        AbstractCampaignRepositoryTypeSupport<CampaignSupportedOnTouch> {

    private static final JooqReader<CampaignSupportedOnTouch> READER = createReader();

    @Autowired
    public CampaignSupportedOnTouchTypeSupport(DslContextProvider dslContextProvider) {
        super(dslContextProvider);
    }

    @Override
    public Class<CampaignSupportedOnTouch> getTypeClass() {
        return CampaignSupportedOnTouch.class;
    }

    @Override
    public Collection<Field<?>> getFields() {
        return READER.getFieldsToRead();
    }

    @Override
    public void fillFromRecord(CampaignSupportedOnTouch campaign, Record record) {
        READER.fromDb(record, campaign);
    }

    private static JooqReader<CampaignSupportedOnTouch> createReader() {
        return JooqReaderBuilder.<CampaignSupportedOnTouch>builder()
                .readProperty(CommonCampaign.IS_TOUCH, fromField(CAMPAIGNS.OPTS).by(CampaignConverter::isTouchFromDb))
                .build();
    }
}
