package ru.yandex.direct.core.entity.campaign.repository.type;

import java.util.Collection;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.Field;
import org.jooq.Record;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithAddMetrikaTagToUrl;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.jooqmapperhelper.InsertHelperAggregator;

import static java.util.Collections.emptyList;
import static ru.yandex.direct.dbschema.ppc.Tables.CAMP_OPTIONS;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithAddMetrikaTagToUrlTypeSupport extends AbstractCampaignRepositoryTypeSupport<CampaignWithAddMetrikaTagToUrl> {

    @Autowired
    public CampaignWithAddMetrikaTagToUrlTypeSupport(DslContextProvider dslContextProvider) {
        super(dslContextProvider);
    }

    @Override
    public Class<CampaignWithAddMetrikaTagToUrl> getTypeClass() {
        return CampaignWithAddMetrikaTagToUrl.class;
    }

    @Override
    public Collection<Field<?>> getFields() {
        return emptyList();
    }

    @Override
    public <M extends CampaignWithAddMetrikaTagToUrl> void fillFromRecord(M campaign, Record record) {
    }

    @Override
    public void pushToInsert(InsertHelperAggregator insertHelperAggregator, CampaignWithAddMetrikaTagToUrl campaign) {
        insertHelperAggregator.getOrCreate(CAMP_OPTIONS).set(CAMP_OPTIONS.STATUS_CLICK_TRACK, 1L);
    }
}
