package ru.yandex.direct.core.entity.campaign.repository.type;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.BudgetDisplayFormat;
import ru.yandex.direct.core.entity.campaign.model.CampaignWithAdditionalDataBudgetDisplayFormat;
import ru.yandex.direct.core.entity.campaign.model.CampaignWithAdditionalDataCampAim;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.jooqmapper.JooqMapper;
import ru.yandex.direct.jooqmapper.JooqMapperBuilder;
import ru.yandex.direct.model.AppliedChanges;

import static ru.yandex.direct.dbschema.ppc.Tables.CAMP_ADDITIONAL_DATA;
import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.convertibleProperty;
import static ru.yandex.direct.jooqmapper.write.WriterBuilders.fromProperty;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithAdditionalDataBudgetDisplayFormatRepositoryTypeSupport extends
        AbstractCampaignWithAdditionalDataRepositorySupport<CampaignWithAdditionalDataBudgetDisplayFormat> {

    private static final JooqMapper<CampaignWithAdditionalDataBudgetDisplayFormat> MAPPER = createMapper();

    @Autowired
    CampaignWithAdditionalDataBudgetDisplayFormatRepositoryTypeSupport(DslContextProvider dslContextProvider) {
        super(dslContextProvider);
    }

    @Override
    protected JooqMapper<CampaignWithAdditionalDataBudgetDisplayFormat> getCampAdditionalDataTableMapper() {
        return MAPPER;
    }

    private static JooqMapper<CampaignWithAdditionalDataBudgetDisplayFormat> createMapper() {
        return JooqMapperBuilder.<CampaignWithAdditionalDataBudgetDisplayFormat>builder()
                .writeField(CAMP_ADDITIONAL_DATA.CID, fromProperty(CampaignWithAdditionalDataCampAim.ID))
                .map(convertibleProperty(CampaignWithAdditionalDataBudgetDisplayFormat.BUDGET_DISPLAY_FORMAT,
                        CAMP_ADDITIONAL_DATA.BUDGET_DISPLAY_FORMAT, BudgetDisplayFormat::fromSource,
                        BudgetDisplayFormat::toSource))
                .build();
    }

    @Override
    public Class<CampaignWithAdditionalDataBudgetDisplayFormat> getTypeClass() {
        return CampaignWithAdditionalDataBudgetDisplayFormat.class;
    }

    @Override
    protected boolean isCampAdditionalDataAdded(CampaignWithAdditionalDataBudgetDisplayFormat campaign) {
        return campaign.getBudgetDisplayFormat() != null;
    }

    @Override
    protected boolean isCampAdditionalDataChanged(AppliedChanges<CampaignWithAdditionalDataBudgetDisplayFormat> appliedChangesItem) {
        return appliedChangesItem.changed(CampaignWithAdditionalDataBudgetDisplayFormat.BUDGET_DISPLAY_FORMAT);
    }

    @Override
    protected boolean isCampAdditionalDataChangedAndDeleted(
            AppliedChanges<CampaignWithAdditionalDataBudgetDisplayFormat> appliedChangesItem) {
        return appliedChangesItem.deleted(CampaignWithAdditionalDataBudgetDisplayFormat.BUDGET_DISPLAY_FORMAT);
    }

    @Override
    protected boolean wasNotPresentBefore(AppliedChanges<CampaignWithAdditionalDataBudgetDisplayFormat> appliedChangesItem) {
        return appliedChangesItem.getOldValue(CampaignWithAdditionalDataBudgetDisplayFormat.BUDGET_DISPLAY_FORMAT) == null;
    }
}
