package ru.yandex.direct.core.entity.campaign.repository.type;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithAdditionalDataBusinessCategory;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.jooqmapper.JooqMapper;
import ru.yandex.direct.jooqmapper.JooqMapperBuilder;
import ru.yandex.direct.model.AppliedChanges;

import static ru.yandex.direct.dbschema.ppc.Tables.CAMP_ADDITIONAL_DATA;
import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.property;
import static ru.yandex.direct.jooqmapper.write.WriterBuilders.fromProperty;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithAdditionalDataBusinessCategoryRepositoryTypeSupport extends
        AbstractCampaignWithAdditionalDataRepositorySupport<CampaignWithAdditionalDataBusinessCategory> {

    private static final JooqMapper<CampaignWithAdditionalDataBusinessCategory> MAPPER = createMapper();

    @Autowired
    public CampaignWithAdditionalDataBusinessCategoryRepositoryTypeSupport(DslContextProvider dslContextProvider) {
        super(dslContextProvider);
    }

    @Override
    protected JooqMapper<CampaignWithAdditionalDataBusinessCategory> getCampAdditionalDataTableMapper() {
        return MAPPER;
    }

    private static JooqMapper<CampaignWithAdditionalDataBusinessCategory> createMapper() {
        return JooqMapperBuilder.<CampaignWithAdditionalDataBusinessCategory>builder()
                .writeField(CAMP_ADDITIONAL_DATA.CID, fromProperty(CampaignWithAdditionalDataBusinessCategory.ID))
                .map(property(CampaignWithAdditionalDataBusinessCategory.BUSINESS_CATEGORY,
                        CAMP_ADDITIONAL_DATA.BUSINESS_CATEGORY))
                .build();
    }

    @Override
    public Class<CampaignWithAdditionalDataBusinessCategory> getTypeClass() {
        return CampaignWithAdditionalDataBusinessCategory.class;
    }

    @Override
    protected boolean isCampAdditionalDataAdded(CampaignWithAdditionalDataBusinessCategory campaign) {
        return campaign.getBusinessCategory() != null;
    }

    @Override
    protected boolean isCampAdditionalDataChanged(AppliedChanges<CampaignWithAdditionalDataBusinessCategory> appliedChangesItem) {
        return appliedChangesItem.changed(CampaignWithAdditionalDataBusinessCategory.BUSINESS_CATEGORY);
    }

    @Override
    protected boolean isCampAdditionalDataChangedAndDeleted(
            AppliedChanges<CampaignWithAdditionalDataBusinessCategory> appliedChangesItem) {
        return appliedChangesItem.deleted(CampaignWithAdditionalDataBusinessCategory.BUSINESS_CATEGORY);
    }

    @Override
    protected boolean wasNotPresentBefore(AppliedChanges<CampaignWithAdditionalDataBusinessCategory> appliedChangesItem) {
        return appliedChangesItem.getOldValue(CampaignWithAdditionalDataBusinessCategory.BUSINESS_CATEGORY) == null;
    }
}
