package ru.yandex.direct.core.entity.campaign.repository.type;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.CampAimType;
import ru.yandex.direct.core.entity.campaign.model.CampaignWithAdditionalDataCampAim;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.jooqmapper.JooqMapper;
import ru.yandex.direct.jooqmapper.JooqMapperBuilder;
import ru.yandex.direct.model.AppliedChanges;

import static ru.yandex.direct.dbschema.ppc.Tables.CAMP_ADDITIONAL_DATA;
import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.convertibleProperty;
import static ru.yandex.direct.jooqmapper.write.WriterBuilders.fromProperty;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithAdditionalDataCampAimRepositoryTypeSupport extends
        AbstractCampaignWithAdditionalDataRepositorySupport<CampaignWithAdditionalDataCampAim> {
    private static final JooqMapper<CampaignWithAdditionalDataCampAim> MAPPER = createMapper();

    @Autowired
    CampaignWithAdditionalDataCampAimRepositoryTypeSupport(DslContextProvider dslContextProvider) {
        super(dslContextProvider);
    }

    @Override
    protected JooqMapper<CampaignWithAdditionalDataCampAim> getCampAdditionalDataTableMapper() {
        return MAPPER;
    }

    private static JooqMapper<CampaignWithAdditionalDataCampAim> createMapper() {
        return JooqMapperBuilder.<CampaignWithAdditionalDataCampAim>builder()
                .writeField(CAMP_ADDITIONAL_DATA.CID, fromProperty(CampaignWithAdditionalDataCampAim.ID))
                .map(convertibleProperty(CampaignWithAdditionalDataCampAim.CAMP_AIM_TYPE,
                        CAMP_ADDITIONAL_DATA.CAMP_AIM_TYPE, CampAimType::fromSource, CampAimType::toSource))
                .build();
    }

    @Override
    public Class<CampaignWithAdditionalDataCampAim> getTypeClass() {
        return CampaignWithAdditionalDataCampAim.class;
    }

    @Override
    protected boolean isCampAdditionalDataAdded(CampaignWithAdditionalDataCampAim campaign) {
        return campaign.getCampAimType() != null;
    }

    @Override
    protected boolean isCampAdditionalDataChanged(AppliedChanges<CampaignWithAdditionalDataCampAim> appliedChangesItem) {
        return appliedChangesItem.changed(CampaignWithAdditionalDataCampAim.CAMP_AIM_TYPE);
    }

    @Override
    protected boolean isCampAdditionalDataChangedAndDeleted(
            AppliedChanges<CampaignWithAdditionalDataCampAim> appliedChangesItem) {
        return appliedChangesItem.deleted(CampaignWithAdditionalDataCampAim.CAMP_AIM_TYPE);
    }

    @Override
    protected boolean wasNotPresentBefore(AppliedChanges<CampaignWithAdditionalDataCampAim> appliedChangesItem) {
        return appliedChangesItem.getOldValue(CampaignWithAdditionalDataCampAim.CAMP_AIM_TYPE) == null;
    }
}
