package ru.yandex.direct.core.entity.campaign.repository.type;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithAdditionalDataCompanyName;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.jooqmapper.JooqMapper;
import ru.yandex.direct.jooqmapper.JooqMapperBuilder;
import ru.yandex.direct.model.AppliedChanges;

import static ru.yandex.direct.dbschema.ppc.Tables.CAMP_ADDITIONAL_DATA;
import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.property;
import static ru.yandex.direct.jooqmapper.write.WriterBuilders.fromProperty;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithAdditionalDataCompanyNameRepositoryTypeSupport extends
        AbstractCampaignWithAdditionalDataRepositorySupport<CampaignWithAdditionalDataCompanyName> {

    private static final JooqMapper<CampaignWithAdditionalDataCompanyName> MAPPER = createMapper();

    @Autowired
    public CampaignWithAdditionalDataCompanyNameRepositoryTypeSupport(DslContextProvider dslContextProvider) {
        super(dslContextProvider);
    }

    @Override
    protected JooqMapper<CampaignWithAdditionalDataCompanyName> getCampAdditionalDataTableMapper() {
        return MAPPER;
    }

    private static JooqMapper<CampaignWithAdditionalDataCompanyName> createMapper() {
        return JooqMapperBuilder.<CampaignWithAdditionalDataCompanyName>builder()
                .writeField(CAMP_ADDITIONAL_DATA.CID, fromProperty(CampaignWithAdditionalDataCompanyName.ID))
                .map(property(CampaignWithAdditionalDataCompanyName.COMPANY_NAME, CAMP_ADDITIONAL_DATA.COMPANY_NAME))
                .build();
    }

    @Override
    public Class<CampaignWithAdditionalDataCompanyName> getTypeClass() {
        return CampaignWithAdditionalDataCompanyName.class;
    }

    @Override
    protected boolean isCampAdditionalDataAdded(CampaignWithAdditionalDataCompanyName campaign) {
        return campaign.getCompanyName() != null;
    }

    @Override
    protected boolean isCampAdditionalDataChanged(AppliedChanges<CampaignWithAdditionalDataCompanyName> appliedChangesItem) {
        return appliedChangesItem.changed(CampaignWithAdditionalDataCompanyName.COMPANY_NAME);
    }

    @Override
    protected boolean isCampAdditionalDataChangedAndDeleted(
            AppliedChanges<CampaignWithAdditionalDataCompanyName> appliedChangesItem) {
        return appliedChangesItem.deleted(CampaignWithAdditionalDataCompanyName.COMPANY_NAME);
    }

    @Override
    protected boolean wasNotPresentBefore(AppliedChanges<CampaignWithAdditionalDataCompanyName> appliedChangesItem) {
        return appliedChangesItem.getOldValue(CampaignWithAdditionalDataCompanyName.COMPANY_NAME) == null;
    }
}
