package ru.yandex.direct.core.entity.campaign.repository.type;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithAdditionalDataHref;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.jooqmapper.JooqMapper;
import ru.yandex.direct.jooqmapper.JooqMapperBuilder;
import ru.yandex.direct.model.AppliedChanges;

import static ru.yandex.direct.dbschema.ppc.Tables.CAMP_ADDITIONAL_DATA;
import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.property;
import static ru.yandex.direct.jooqmapper.write.WriterBuilders.fromProperty;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithAdditionalDataHrefRepositoryTypeSupport extends
        AbstractCampaignWithAdditionalDataRepositorySupport<CampaignWithAdditionalDataHref> {

    private static final JooqMapper<CampaignWithAdditionalDataHref> MAPPER = createMapper();

    @Autowired
    public CampaignWithAdditionalDataHrefRepositoryTypeSupport(DslContextProvider dslContextProvider) {
        super(dslContextProvider);
    }

    @Override
    protected JooqMapper<CampaignWithAdditionalDataHref> getCampAdditionalDataTableMapper() {
        return MAPPER;
    }

    private static JooqMapper<CampaignWithAdditionalDataHref> createMapper() {
        return JooqMapperBuilder.<CampaignWithAdditionalDataHref>builder()
                .writeField(CAMP_ADDITIONAL_DATA.CID, fromProperty(CampaignWithAdditionalDataHref.ID))
                .map(property(CampaignWithAdditionalDataHref.HREF, CAMP_ADDITIONAL_DATA.HREF))
                .build();
    }

    @Override
    public Class<CampaignWithAdditionalDataHref> getTypeClass() {
        return CampaignWithAdditionalDataHref.class;
    }

    @Override
    protected boolean isCampAdditionalDataAdded(CampaignWithAdditionalDataHref campaign) {
        return campaign.getHref() != null;
    }

    @Override
    protected boolean isCampAdditionalDataChanged(AppliedChanges<CampaignWithAdditionalDataHref> appliedChangesItem) {
        return appliedChangesItem.changed(CampaignWithAdditionalDataHref.HREF);
    }

    @Override
    protected boolean isCampAdditionalDataChangedAndDeleted(
            AppliedChanges<CampaignWithAdditionalDataHref> appliedChangesItem) {
        return appliedChangesItem.deleted(CampaignWithAdditionalDataHref.HREF);
    }

    @Override
    protected boolean wasNotPresentBefore(AppliedChanges<CampaignWithAdditionalDataHref> appliedChangesItem) {
        return appliedChangesItem.getOldValue(CampaignWithAdditionalDataHref.HREF) == null;
    }
}
