package ru.yandex.direct.core.entity.campaign.repository.type;

import java.util.Collection;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.Field;
import org.jooq.Record;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.converter.CampaignConverter;
import ru.yandex.direct.core.entity.campaign.model.CampaignWithAllowedOnAdultContent;
import ru.yandex.direct.core.entity.campaign.model.CommonCampaign;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.jooqmapper.read.JooqReader;
import ru.yandex.direct.jooqmapper.read.JooqReaderBuilder;

import static ru.yandex.direct.dbschema.ppc.tables.Campaigns.CAMPAIGNS;
import static ru.yandex.direct.jooqmapper.read.ReaderBuilders.fromField;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithAllowedOnAdultContentTypeSupport extends
        AbstractCampaignRepositoryTypeSupport<CampaignWithAllowedOnAdultContent> {

    private static final JooqReader<CampaignWithAllowedOnAdultContent> READER = createReader();

    @Autowired
    public CampaignWithAllowedOnAdultContentTypeSupport(DslContextProvider dslContextProvider) {
        super(dslContextProvider);
    }

    @Override
    public Class<CampaignWithAllowedOnAdultContent> getTypeClass() {
        return CampaignWithAllowedOnAdultContent.class;
    }

    @Override
    public Collection<Field<?>> getFields() {
        return READER.getFieldsToRead();
    }

    @Override
    public void fillFromRecord(CampaignWithAllowedOnAdultContent campaign, Record record) {
        READER.fromDb(record, campaign);
    }

    private static JooqReader<CampaignWithAllowedOnAdultContent> createReader() {
        return JooqReaderBuilder.<CampaignWithAllowedOnAdultContent>builder()
                .readProperty(CommonCampaign.IS_ALLOWED_ON_ADULT_CONTENT, fromField(CAMPAIGNS.OPTS).by(
                        CampaignConverter::isAllowedOnAdultContentFromDb))
                .build();
    }
}
