package ru.yandex.direct.core.entity.campaign.repository.type;

import java.util.Collection;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.Field;
import org.jooq.Record;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithAllowedPageIds;
import ru.yandex.direct.core.entity.campaign.repository.CampaignMappings;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.jooqmapper.JooqMapper;
import ru.yandex.direct.jooqmapper.JooqMapperBuilder;
import ru.yandex.direct.jooqmapperhelper.InsertHelperAggregator;
import ru.yandex.direct.jooqmapperhelper.UpdateHelperAggregator;
import ru.yandex.direct.model.AppliedChanges;

import static ru.yandex.direct.dbschema.ppc.Tables.CAMP_OPTIONS;
import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.convertibleProperty;
import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.property;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithAllowedPageIdsTypeSupport extends AbstractCampaignRepositoryTypeSupport<CampaignWithAllowedPageIds> {
    private static final JooqMapper<CampaignWithAllowedPageIds> MAPPER =
            createCampaignWithAllowedPageIdsMapper();

    @Autowired
    CampaignWithAllowedPageIdsTypeSupport(DslContextProvider dslContextProvider) {
        super(dslContextProvider);
    }

    @Override
    public void processUpdate(UpdateHelperAggregator updateHelperAggregator,
                              Collection<AppliedChanges<CampaignWithAllowedPageIds>> appliedChanges) {
        updateHelperAggregator.getOrCreate(CAMP_OPTIONS.CID)
                .processUpdateAll(MAPPER, appliedChanges);
    }

    @Override
    public void pushToInsert(InsertHelperAggregator insertHelperAggregator,
                             CampaignWithAllowedPageIds campaign) {
        insertHelperAggregator.getOrCreate(CAMP_OPTIONS).add(MAPPER, campaign);
    }

    @Override
    public Collection<Field<?>> getFields() {
        return MAPPER.getFieldsToRead();
    }

    @Override
    public <M extends CampaignWithAllowedPageIds> void fillFromRecord(M campaign, Record record) {
        MAPPER.fromDb(record, campaign);
    }

    @Override
    public Class<CampaignWithAllowedPageIds> getTypeClass() {
        return CampaignWithAllowedPageIds.class;
    }

    private static JooqMapper<CampaignWithAllowedPageIds> createCampaignWithAllowedPageIdsMapper() {
        return JooqMapperBuilder.<CampaignWithAllowedPageIds>builder()
                .map(property(CampaignWithAllowedPageIds.ID, CAMP_OPTIONS.CID))
                .map(convertibleProperty(CampaignWithAllowedPageIds.ALLOWED_PAGE_IDS, CAMP_OPTIONS.ALLOWED_PAGE_IDS,
                        CampaignMappings::pageIdsFromDbNullWhenEmpty, CampaignMappings::pageIdsToDb))
                .map(convertibleProperty(CampaignWithAllowedPageIds.ALLOWED_DOMAINS, CAMP_OPTIONS.ALLOWED_DOMAINS,
                        CampaignMappings::stringListFromDbJsonFormat,
                        CampaignMappings::stringListToDbJsonFormat))
                .map(convertibleProperty(CampaignWithAllowedPageIds.ALLOWED_SSP, CAMP_OPTIONS.ALLOWED_SSP,
                        CampaignMappings::stringListFromDbJsonFormat,
                        CampaignMappings::stringListToDbJsonFormat))
                .build();
    }
}
