package ru.yandex.direct.core.entity.campaign.repository.type;

import java.util.Collection;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.Field;
import org.jooq.Record;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.CampaignAttributionModel;
import ru.yandex.direct.core.entity.campaign.model.CampaignWithAttributionModel;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.jooqmapper.JooqMapper;
import ru.yandex.direct.jooqmapper.JooqMapperBuilder;
import ru.yandex.direct.jooqmapperhelper.InsertHelperAggregator;
import ru.yandex.direct.jooqmapperhelper.UpdateHelperAggregator;
import ru.yandex.direct.model.AppliedChanges;

import static ru.yandex.direct.dbschema.ppc.Tables.CAMPAIGNS;
import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.convertibleProperty;
import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.property;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithAttributionModelTypeSupport extends AbstractCampaignRepositoryTypeSupport<CampaignWithAttributionModel> {
    private static final JooqMapper<CampaignWithAttributionModel> MAPPER =
            createCampaignWithContentLanguageMapper();

    @Autowired
    CampaignWithAttributionModelTypeSupport(DslContextProvider dslContextProvider) {
        super(dslContextProvider);
    }

    @Override
    public void processUpdate(UpdateHelperAggregator updateHelperAggregator,
                              Collection<AppliedChanges<CampaignWithAttributionModel>> appliedChanges) {
        updateHelperAggregator.getOrCreate(CAMPAIGNS.CID)
                .processUpdateAll(MAPPER, appliedChanges);
    }

    @Override
    public void pushToInsert(InsertHelperAggregator insertHelperAggregator,
                             CampaignWithAttributionModel campaign) {
        insertHelperAggregator.getOrCreate(CAMPAIGNS).add(MAPPER, campaign);
    }

    @Override
    public Collection<Field<?>> getFields() {
        return MAPPER.getFieldsToRead();
    }

    @Override
    public <M extends CampaignWithAttributionModel> void fillFromRecord(M campaign, Record record) {
        MAPPER.fromDb(record, campaign);
    }

    @Override
    public Class<CampaignWithAttributionModel> getTypeClass() {
        return CampaignWithAttributionModel.class;
    }

    private static JooqMapper<CampaignWithAttributionModel> createCampaignWithContentLanguageMapper() {
        return JooqMapperBuilder.<CampaignWithAttributionModel>builder()
                .map(property(CampaignWithAttributionModel.ID, CAMPAIGNS.CID))
                .map(convertibleProperty(CampaignWithAttributionModel.ATTRIBUTION_MODEL, CAMPAIGNS.ATTRIBUTION_MODEL,
                        CampaignAttributionModel::fromSource, CampaignAttributionModel::toSource))
                .build();
    }
}
