package ru.yandex.direct.core.entity.campaign.repository.type

import org.jooq.Field
import org.jooq.JoinType
import org.jooq.Record
import org.springframework.stereotype.Component
import ru.yandex.direct.core.entity.campaign.model.CampaignWithBannerHrefParams
import ru.yandex.direct.dbschema.ppc.Tables
import ru.yandex.direct.dbutil.wrapper.DslContextProvider
import ru.yandex.direct.jooqmapper.JooqMapperBuilder
import ru.yandex.direct.jooqmapper.ReaderWriterBuilders.property
import ru.yandex.direct.jooqmapperhelper.InsertHelperAggregator
import ru.yandex.direct.jooqmapperhelper.UpdateHelperAggregator
import ru.yandex.direct.model.AppliedChanges
import ru.yandex.direct.multitype.entity.JoinQuery
import javax.annotation.ParametersAreNonnullByDefault

@Component
@ParametersAreNonnullByDefault
class CampaignWithBannerHrefParamsRepositoryTypeSupport(
    dslContextProvider: DslContextProvider,
) : AbstractCampaignRepositoryTypeSupport<CampaignWithBannerHrefParams>(
    dslContextProvider,
) {
    private companion object {
        private val mapper = JooqMapperBuilder.builder<CampaignWithBannerHrefParams>()
            .map(property(CampaignWithBannerHrefParams.ID, Tables.CAMP_OPTIONS.CID))
            .map(property(CampaignWithBannerHrefParams.BANNER_HREF_PARAMS, Tables.CAMP_OPTIONS.HREF_PARAMS))
            .build()
    }

    override fun getTypeClass() = CampaignWithBannerHrefParams::class.java

    override fun getFields(): Collection<Field<*>> = mapper.fieldsToRead

    override fun joinQuery(): List<JoinQuery> =
        listOf(
            JoinQuery(
                Tables.CAMP_OPTIONS,
                JoinType.LEFT_OUTER_JOIN,
                Tables.CAMP_OPTIONS.CID.eq(Tables.CAMPAIGNS.CID)
            ),
        )

    override fun <M : CampaignWithBannerHrefParams> fillFromRecord(model: M, record: Record) {
        mapper.fromDb(record, model)
    }

    override fun processUpdate(
        updateHelperAggregator: UpdateHelperAggregator,
        appliedChanges: Collection<AppliedChanges<CampaignWithBannerHrefParams>>
    ) {
        updateHelperAggregator
            .getOrCreate(Tables.CAMP_OPTIONS.CID)
            .processUpdateAll(mapper, appliedChanges)
    }

    override fun pushToInsert(
        insertHelperAggregator: InsertHelperAggregator,
        campaign: CampaignWithBannerHrefParams
    ) {
        insertHelperAggregator
            .getOrCreate(Tables.CAMP_OPTIONS)
            .add(mapper, campaign)
    }
}
