package ru.yandex.direct.core.entity.campaign.repository.type;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

import javax.annotation.ParametersAreNonnullByDefault;

import one.util.streamex.StreamEx;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.Record;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.bidmodifier.BidModifier;
import ru.yandex.direct.core.entity.bidmodifiers.Constants;
import ru.yandex.direct.core.entity.bidmodifiers.repository.BidModifierLevel;
import ru.yandex.direct.core.entity.bidmodifiers.service.BidModifierService;
import ru.yandex.direct.core.entity.campaign.model.CampaignWithBidModifiers;
import ru.yandex.direct.core.entity.campaign.service.type.add.container.RestrictedCampaignsAddOperationContainer;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;

import static ru.yandex.direct.utils.FunctionalUtils.listToSet;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithBidModifiersTypeSupport extends AbstractCampaignRepositoryTypeSupport<CampaignWithBidModifiers> {
    private final BidModifierService bidModifierService;

    @Autowired
    public CampaignWithBidModifiersTypeSupport(DslContextProvider dslContextProvider,
                                               BidModifierService bidModifierService) {
        super(dslContextProvider);
        this.bidModifierService = bidModifierService;
    }

    @Override
    public Collection<Field<?>> getFields() {
        return Collections.emptySet();
    }

    @Override
    public <M extends CampaignWithBidModifiers> void fillFromRecord(M campaign, Record record) {
    }

    @Override
    public Class<CampaignWithBidModifiers> getTypeClass() {
        return CampaignWithBidModifiers.class;
    }

    @Override
    public void insertToAdditionTables(DSLContext context,
                                       RestrictedCampaignsAddOperationContainer addCampaignParametersContainer,
                                       Collection<CampaignWithBidModifiers> campaigns) {
        campaigns.stream()
                .filter(c -> c.getBidModifiers() != null)
                .forEach(c -> c.getBidModifiers().forEach(bm -> bm.setCampaignId(c.getId())));

        List<BidModifier> bidModifiers = StreamEx.of(campaigns)
                .flatCollection(CampaignWithBidModifiers::getBidModifiers)
                .nonNull()
                .toList();

        bidModifierService.replaceCampaignModifiers(context, addCampaignParametersContainer.getClientId(),
                addCampaignParametersContainer.getOperatorUid(), bidModifiers,
                listToSet(campaigns, CampaignWithBidModifiers::getId)
        );
    }

    @Override
    public void enrichModelFromOtherTables(DSLContext dslContext, Collection<CampaignWithBidModifiers> campaigns) {
        Set<Long> campaignIds = listToSet(campaigns, CampaignWithBidModifiers::getId);
        List<BidModifier> bidModifiers = bidModifierService.getByCampaignIds(
                dslContext,
                campaignIds,
                Constants.ALL_TYPES,
                Set.of(BidModifierLevel.CAMPAIGN));

        Map<Long, List<BidModifier>> bidModifiersByCampaigns = StreamEx.of(bidModifiers)
                .mapToEntry(BidModifier::getCampaignId, Function.identity())
                .grouping();
        campaigns.forEach(campaign -> campaign.setBidModifiers(bidModifiersByCampaigns.get(campaign.getId())));
    }
}
