package ru.yandex.direct.core.entity.campaign.repository.type;

import java.util.Collection;
import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.Field;
import org.jooq.Record;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.common.util.RepositoryUtils;
import ru.yandex.direct.core.entity.campaign.converter.CampaignConverter;
import ru.yandex.direct.core.entity.campaign.model.BroadMatch;
import ru.yandex.direct.core.entity.campaign.model.CampaignWithBroadMatch;
import ru.yandex.direct.dbschema.ppc.enums.CampOptionsBroadMatchFlag;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.jooqmapper.JooqMapper;
import ru.yandex.direct.jooqmapper.JooqMapperBuilder;
import ru.yandex.direct.jooqmapperhelper.InsertHelperAggregator;
import ru.yandex.direct.jooqmapperhelper.UpdateHelperAggregator;
import ru.yandex.direct.model.AppliedChanges;

import static ru.yandex.direct.dbschema.ppc.Tables.CAMP_OPTIONS;
import static ru.yandex.direct.jooqmapper.read.ReaderBuilders.fromFields;
import static ru.yandex.direct.jooqmapper.write.WriterBuilders.fromProperty;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithBroadMatchTypeSupport extends AbstractCampaignRepositoryTypeSupport<CampaignWithBroadMatch> {

    private static final JooqMapper<CampaignWithBroadMatch> MAPPER = createMapper();

    @Autowired
    public CampaignWithBroadMatchTypeSupport(DslContextProvider dslContextProvider) {
        super(dslContextProvider);
    }

    @Override
    public Class<CampaignWithBroadMatch> getTypeClass() {
        return CampaignWithBroadMatch.class;
    }

    @Override
    public Collection<Field<?>> getFields() {
        return MAPPER.getFieldsToRead();
    }

    @Override
    public void processUpdate(UpdateHelperAggregator updateHelperAggregator,
                              Collection<AppliedChanges<CampaignWithBroadMatch>> appliedChanges) {
        updateHelperAggregator.getOrCreate(CAMP_OPTIONS.CID).processUpdateAll(MAPPER, appliedChanges);
    }

    @Override
    public void pushToInsert(InsertHelperAggregator insertHelperAggregator, CampaignWithBroadMatch campaign) {
        insertHelperAggregator.getOrCreate(CAMP_OPTIONS).add(MAPPER, campaign);
    }

    @Override
    public void fillFromRecord(CampaignWithBroadMatch campaign, Record record) {
        MAPPER.fromDb(record, campaign);
    }

    private static JooqMapper<CampaignWithBroadMatch> createMapper() {
        return JooqMapperBuilder.<CampaignWithBroadMatch>builder()
                .writeField(CAMP_OPTIONS.BROAD_MATCH_FLAG, fromProperty(CampaignWithBroadMatch.BROAD_MATCH)
                        .by(b -> RepositoryUtils.booleanToYesNo(b.getBroadMatchFlag(),
                                CampOptionsBroadMatchFlag.class)))
                .writeField(CAMP_OPTIONS.BROAD_MATCH_LIMIT, fromProperty(CampaignWithBroadMatch.BROAD_MATCH)
                        .by(broadMatch -> RepositoryUtils.intToLong(broadMatch.getBroadMatchLimit())))
                .writeField(CAMP_OPTIONS.BROAD_MATCH_GOAL_ID, fromProperty(CampaignWithBroadMatch.BROAD_MATCH)
                        .by(BroadMatch::getBroadMatchGoalId))
                .readProperty(CampaignWithBroadMatch.BROAD_MATCH, fromFields(List.of(CAMP_OPTIONS.BROAD_MATCH_FLAG,
                        CAMP_OPTIONS.BROAD_MATCH_LIMIT, CAMP_OPTIONS.BROAD_MATCH_GOAL_ID))
                        .by(CampaignConverter::broadMatchFromDb))
                .build();
    }
}
