package ru.yandex.direct.core.entity.campaign.repository.type;

import java.util.Collection;
import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.JoinType;
import org.jooq.Record;
import org.jooq.util.mysql.MySQLDSL;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithCalltrackingOnSite;
import ru.yandex.direct.core.entity.campaign.service.type.add.container.RestrictedCampaignsAddOperationContainer;
import ru.yandex.direct.core.entity.campaign.service.type.update.container.RestrictedCampaignsUpdateOperationContainer;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.jooqmapper.JooqMapper;
import ru.yandex.direct.jooqmapper.JooqMapperBuilder;
import ru.yandex.direct.jooqmapperhelper.InsertHelper;
import ru.yandex.direct.model.AppliedChanges;
import ru.yandex.direct.multitype.entity.JoinQuery;

import static ru.yandex.direct.dbschema.ppc.Tables.CAMPAIGNS;
import static ru.yandex.direct.dbschema.ppc.Tables.CAMP_CALLTRACKING_SETTINGS;
import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.property;
import static ru.yandex.direct.jooqmapper.write.WriterBuilders.fromProperty;
import static ru.yandex.direct.utils.FunctionalUtils.filterAndMapList;
import static ru.yandex.direct.utils.FunctionalUtils.filterList;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithCalltrackingOnSiteTypeSupport
        extends AbstractCampaignRepositoryTypeSupport<CampaignWithCalltrackingOnSite> {

    private static final JooqMapper<CampaignWithCalltrackingOnSite> MAPPER = createMapper();

    @Autowired
    public CampaignWithCalltrackingOnSiteTypeSupport(DslContextProvider dslContextProvider) {
        super(dslContextProvider);
    }

    @Override
    public Class<CampaignWithCalltrackingOnSite> getTypeClass() {
        return CampaignWithCalltrackingOnSite.class;
    }

    @Override
    public Collection<Field<?>> getFields() {
        return MAPPER.getFieldsToRead();
    }

    @Override
    public List<JoinQuery> joinQuery() {
        return List.of(new JoinQuery(
                CAMP_CALLTRACKING_SETTINGS,
                JoinType.LEFT_OUTER_JOIN,
                CAMP_CALLTRACKING_SETTINGS.CID.eq(CAMPAIGNS.CID)
        ));
    }

    @Override
    public void fillFromRecord(CampaignWithCalltrackingOnSite campaign, Record record) {
        MAPPER.fromDb(record, campaign);
    }

    @Override
    public void updateAdditionTables(DSLContext context, RestrictedCampaignsUpdateOperationContainer updateParameters,
                                     Collection<AppliedChanges<CampaignWithCalltrackingOnSite>> appliedChanges) {

        List<Long> idsToDelete = filterAndMapList(appliedChanges,
                ac -> ac.deleted(CampaignWithCalltrackingOnSite.CALLTRACKING_SETTINGS_ID),
                ac -> ac.getModel().getId());

        if (!idsToDelete.isEmpty()) {
            context.deleteFrom(CAMP_CALLTRACKING_SETTINGS).where(CAMP_CALLTRACKING_SETTINGS.CID.in(idsToDelete)).execute();
        }

        List<CampaignWithCalltrackingOnSite> campaignsToUpdate = filterAndMapList(appliedChanges,
                ac -> ac.changedAndNotDeleted(CampaignWithCalltrackingOnSite.CALLTRACKING_SETTINGS_ID),
                AppliedChanges::getModel);

        updateCampaignCalltrackingSettingsIds(context, campaignsToUpdate);
    }

    @Override
    public void insertToAdditionTables(DSLContext context, RestrictedCampaignsAddOperationContainer addModelParametersContainer,
                                       Collection<CampaignWithCalltrackingOnSite> models) {
        List<CampaignWithCalltrackingOnSite> campaignsToInsert =
                filterList(models, campaign -> campaign.getCalltrackingSettingsId() != null);
        updateCampaignCalltrackingSettingsIds(context, campaignsToInsert);
    }

    private static JooqMapper<CampaignWithCalltrackingOnSite> createMapper() {
        return JooqMapperBuilder.<CampaignWithCalltrackingOnSite>builder()
                .writeField(CAMP_CALLTRACKING_SETTINGS.CID, fromProperty(CampaignWithCalltrackingOnSite.ID))
                .map(property(CampaignWithCalltrackingOnSite.CALLTRACKING_SETTINGS_ID,
                        CAMP_CALLTRACKING_SETTINGS.CALLTRACKING_SETTINGS_ID))
                .build();
    }

    private void updateCampaignCalltrackingSettingsIds(DSLContext context, List<CampaignWithCalltrackingOnSite> campaignsToUpdate) {
        var insertHelper = new InsertHelper<>(context, CAMP_CALLTRACKING_SETTINGS);
        insertHelper.addAll(MAPPER, campaignsToUpdate);
        if (insertHelper.hasAddedRecords()) {
            insertHelper.onDuplicateKeyUpdate().set(CAMP_CALLTRACKING_SETTINGS.CALLTRACKING_SETTINGS_ID,
                    MySQLDSL.values(CAMP_CALLTRACKING_SETTINGS.CALLTRACKING_SETTINGS_ID));
        }
        insertHelper.executeIfRecordsAdded();
    }
}
