package ru.yandex.direct.core.entity.campaign.repository.type

import org.jooq.Record
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component
import ru.yandex.direct.core.entity.campaign.model.CampaignType
import ru.yandex.direct.core.entity.campaign.model.CampaignWithCampaignType
import ru.yandex.direct.core.entity.campaign.model.CommonCampaign
import ru.yandex.direct.dbschema.ppc.Tables
import ru.yandex.direct.dbschema.ppc.tables.Campaigns.CAMPAIGNS
import ru.yandex.direct.dbutil.wrapper.DslContextProvider
import ru.yandex.direct.jooqmapper.JooqMapperBuilder
import ru.yandex.direct.jooqmapper.ReaderWriterBuilders.convertibleProperty
import javax.annotation.ParametersAreNonnullByDefault

@Component
@ParametersAreNonnullByDefault
class CampaignWithCampaignTypeRepositoryTypeSupport @Autowired constructor(dslContextProvider: DslContextProvider) :
        AbstractCampaignRepositoryTypeSupport<CampaignWithCampaignType>(dslContextProvider) {

    companion object {
        private val MAPPER = JooqMapperBuilder.builder<CampaignWithCampaignType>()
            .map(convertibleProperty(CommonCampaign.TYPE, CAMPAIGNS.TYPE, CampaignType::fromSource,
                CampaignType::toSource))
            .build()

    }

    override fun getFields() = listOf(Tables.CAMPAIGNS.TYPE)

    override fun <M : CampaignWithCampaignType> fillFromRecord(campaign: M, record: Record) {
        MAPPER.fromDb(record, campaign)
    }

    override fun getTypeClass() = CampaignWithCampaignType::class.java

}
