package ru.yandex.direct.core.entity.campaign.repository.type;

import java.util.Collection;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.Field;
import org.jooq.Record;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.CampaignWarnPlaceInterval;
import ru.yandex.direct.core.entity.campaign.model.CampaignWithCheckPositionEvent;
import ru.yandex.direct.dbschema.ppc.enums.CampOptionsSendwarn;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.jooqmapper.JooqMapper;
import ru.yandex.direct.jooqmapper.JooqMapperBuilder;
import ru.yandex.direct.jooqmapperhelper.InsertHelperAggregator;
import ru.yandex.direct.jooqmapperhelper.UpdateHelperAggregator;
import ru.yandex.direct.model.AppliedChanges;

import static ru.yandex.direct.common.jooqmapperex.ReaderWriterBuildersEx.booleanProperty;
import static ru.yandex.direct.dbschema.ppc.Tables.CAMP_OPTIONS;
import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.convertibleProperty;
import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.property;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithCheckPositionEventTypeSupport extends AbstractCampaignRepositoryTypeSupport<CampaignWithCheckPositionEvent> {

    private static final JooqMapper<CampaignWithCheckPositionEvent> MAPPER = createMapper();

    @Autowired
    public CampaignWithCheckPositionEventTypeSupport(DslContextProvider dslContextProvider) {
        super(dslContextProvider);
    }

    @Override
    public Class<CampaignWithCheckPositionEvent> getTypeClass() {
        return CampaignWithCheckPositionEvent.class;
    }

    @Override
    public Collection<Field<?>> getFields() {
        return MAPPER.getFieldsToRead();
    }

    @Override
    public void processUpdate(UpdateHelperAggregator updateHelperAggregator,
                              Collection<AppliedChanges<CampaignWithCheckPositionEvent>> appliedChanges) {
        updateHelperAggregator.getOrCreate(CAMP_OPTIONS.CID).processUpdateAll(MAPPER, appliedChanges);
    }

    @Override
    public void pushToInsert(InsertHelperAggregator insertHelperAggregator, CampaignWithCheckPositionEvent campaign) {
        insertHelperAggregator.getOrCreate(CAMP_OPTIONS).add(MAPPER, campaign);
    }

    @Override
    public void fillFromRecord(CampaignWithCheckPositionEvent campaign, Record record) {
        MAPPER.fromDb(record, campaign);
    }

    private static JooqMapper<CampaignWithCheckPositionEvent> createMapper() {
        return JooqMapperBuilder.<CampaignWithCheckPositionEvent>builder()
                .map(property(CampaignWithCheckPositionEvent.ID, CAMP_OPTIONS.CID))
                .map(convertibleProperty(CampaignWithCheckPositionEvent.CHECK_POSITION_INTERVAL_EVENT,
                        CAMP_OPTIONS.WARN_PLACE_INTERVAL,
                        CampaignWarnPlaceInterval::fromSource,
                        CampaignWarnPlaceInterval::toSource))
                .map(booleanProperty(CampaignWithCheckPositionEvent.ENABLE_CHECK_POSITION_EVENT,
                        CAMP_OPTIONS.SEND_WARN,
                        CampOptionsSendwarn.class))
                .build();
    }

}
