package ru.yandex.direct.core.entity.campaign.repository.type

import org.jooq.Field
import org.jooq.Record
import org.springframework.stereotype.Component
import ru.yandex.direct.core.entity.campaign.model.CampaignWithClicks
import ru.yandex.direct.dbschema.ppc.Tables.CAMPAIGNS
import ru.yandex.direct.dbutil.wrapper.DslContextProvider
import ru.yandex.direct.jooqmapper.JooqMapperBuilder
import ru.yandex.direct.jooqmapper.ReaderWriterBuilders.property
import ru.yandex.direct.jooqmapperhelper.InsertHelperAggregator
import ru.yandex.direct.jooqmapperhelper.UpdateHelperAggregator
import ru.yandex.direct.model.AppliedChanges

@Component
class CampaignWithClicksTypeSupport(
    dslContextProvider: DslContextProvider,
) : AbstractCampaignRepositoryTypeSupport<CampaignWithClicks>(
    dslContextProvider,
) {
    override fun getTypeClass() = CampaignWithClicks::class.java

    override fun getFields(): Collection<Field<*>> = mapper.fieldsToRead

    override fun <M : CampaignWithClicks> fillFromRecord(model: M, record: Record) {
        mapper.fromDb(record, model)
    }

    override fun processUpdate(
        updateHelperAggregator: UpdateHelperAggregator,
        appliedChanges: Collection<AppliedChanges<CampaignWithClicks>>
    ) {
        updateHelperAggregator
            .getOrCreate(CAMPAIGNS.CID)
            .processUpdateAll(mapper, appliedChanges)
    }

    override fun pushToInsert(
        insertHelperAggregator: InsertHelperAggregator,
        campaign: CampaignWithClicks
    ) {
        insertHelperAggregator
            .getOrCreate(CAMPAIGNS)
            .add(mapper, campaign)
    }

    private companion object {
        private val mapper = JooqMapperBuilder.builder<CampaignWithClicks>()
            .map(property(CampaignWithClicks.ID, CAMPAIGNS.CID))
            .map(property(CampaignWithClicks.CLICKS, CAMPAIGNS.CLICKS))
            .build()
    }
}
