package ru.yandex.direct.core.entity.campaign.repository.type;

import java.util.Collection;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.Field;
import org.jooq.Record;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.converter.CampaignConverter;
import ru.yandex.direct.core.entity.campaign.model.CampaignWithContactInfo;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.jooqmapper.JooqMapper;
import ru.yandex.direct.jooqmapper.JooqMapperBuilder;
import ru.yandex.direct.jooqmapperhelper.InsertHelperAggregator;
import ru.yandex.direct.jooqmapperhelper.UpdateHelperAggregator;
import ru.yandex.direct.model.AppliedChanges;

import static ru.yandex.direct.dbschema.ppc.Tables.CAMP_OPTIONS;
import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.convertibleProperty;
import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.property;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithContactInfoTypeSupport extends AbstractCampaignRepositoryTypeSupport<CampaignWithContactInfo> {
    private static final JooqMapper<CampaignWithContactInfo> MAPPER = createCampaignWithContactInfoMapper();

    @Autowired
    CampaignWithContactInfoTypeSupport(DslContextProvider dslContextProvider) {
        super(dslContextProvider);
    }

    @Override
    public Collection<Field<?>> getFields() {
        return MAPPER.getFieldsToRead();
    }

    @Override
    public <M extends CampaignWithContactInfo> void fillFromRecord(M campaign, Record record) {
        MAPPER.fromDb(record, campaign);
    }

    @Override
    public Class<CampaignWithContactInfo> getTypeClass() {
        return CampaignWithContactInfo.class;
    }

    @Override
    public void processUpdate(UpdateHelperAggregator updateHelperAggregator,
                              Collection<AppliedChanges<CampaignWithContactInfo>> appliedChanges) {
        updateHelperAggregator.getOrCreate(CAMP_OPTIONS.CID).processUpdateAll(MAPPER, appliedChanges);
    }

    @Override
    public void pushToInsert(InsertHelperAggregator insertHelperAggregator, CampaignWithContactInfo campaign) {
        insertHelperAggregator.getOrCreate(CAMP_OPTIONS).add(MAPPER, campaign);
    }

    private static JooqMapper<CampaignWithContactInfo> createCampaignWithContactInfoMapper() {
        return JooqMapperBuilder.<CampaignWithContactInfo>builder()
                .map(property(CampaignWithContactInfo.ID, CAMP_OPTIONS.CID))
                .map(convertibleProperty(CampaignWithContactInfo.CONTACT_INFO, CAMP_OPTIONS.CONTACTINFO,
                        CampaignConverter::vcardFromDb,
                        CampaignConverter::vcardToDb))
                .build();
    }

}
