package ru.yandex.direct.core.entity.campaign.repository.type;

import java.util.Collection;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.Field;
import org.jooq.Record;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithContentLanguage;
import ru.yandex.direct.core.entity.campaign.model.ContentLanguage;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.jooqmapper.JooqMapper;
import ru.yandex.direct.jooqmapper.JooqMapperBuilder;
import ru.yandex.direct.jooqmapperhelper.InsertHelperAggregator;
import ru.yandex.direct.jooqmapperhelper.UpdateHelperAggregator;
import ru.yandex.direct.model.AppliedChanges;

import static ru.yandex.direct.dbschema.ppc.Tables.CAMP_OPTIONS;
import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.convertibleProperty;
import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.property;
import static ru.yandex.direct.utils.CommonUtils.ifNotNull;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithContentLanguageTypeSupport extends AbstractCampaignRepositoryTypeSupport<CampaignWithContentLanguage> {
    private static final JooqMapper<CampaignWithContentLanguage> MAPPER =
            createCampaignWithContentLanguageMapper();

    @Autowired
    CampaignWithContentLanguageTypeSupport(DslContextProvider dslContextProvider) {
        super(dslContextProvider);
    }

    private static JooqMapper<CampaignWithContentLanguage> createCampaignWithContentLanguageMapper() {
        return JooqMapperBuilder.<CampaignWithContentLanguage>builder()
                .map(property(CampaignWithContentLanguage.ID, CAMP_OPTIONS.CID))
                .map(convertibleProperty(CampaignWithContentLanguage.CONTENT_LANGUAGE, CAMP_OPTIONS.CONTENT_LANG,
                        ContentLanguage::fromTypedValue,
                        language -> ifNotNull(language, ContentLanguage::getTypedValue)))
                .build();
    }

    @Override
    public void processUpdate(UpdateHelperAggregator updateHelperAggregator,
                              Collection<AppliedChanges<CampaignWithContentLanguage>> appliedChanges) {
        updateHelperAggregator.getOrCreate(CAMP_OPTIONS.CID).processUpdateAll(MAPPER, appliedChanges);
    }

    @Override
    public void pushToInsert(InsertHelperAggregator insertHelperAggregator, CampaignWithContentLanguage campaign) {
        insertHelperAggregator.getOrCreate(CAMP_OPTIONS).add(MAPPER, campaign);
    }

    @Override
    public Collection<Field<?>> getFields() {
        return MAPPER.getFieldsToRead();
    }

    @Override
    public <M extends CampaignWithContentLanguage> void fillFromRecord(M campaign, Record record) {
        MAPPER.fromDb(record, campaign);
    }

    @Override
    public Class<CampaignWithContentLanguage> getTypeClass() {
        return CampaignWithContentLanguage.class;
    }
}
