package ru.yandex.direct.core.entity.campaign.repository.type

import org.jooq.Field
import org.jooq.Record
import org.springframework.stereotype.Component
import ru.yandex.direct.core.entity.campaign.model.CampaignWithCurrencyConverted
import ru.yandex.direct.core.entity.campaign.repository.CampaignMappings
import ru.yandex.direct.dbschema.ppc.Tables.CAMPAIGNS
import ru.yandex.direct.dbutil.wrapper.DslContextProvider
import ru.yandex.direct.jooqmapper.JooqMapperBuilder
import ru.yandex.direct.jooqmapper.ReaderWriterBuilders.convertibleProperty
import ru.yandex.direct.jooqmapper.ReaderWriterBuilders.property

@Component
class CampaignWithCurrencyConvertedTypeSupport(
    dslContextProvider: DslContextProvider
) : AbstractCampaignRepositoryTypeSupport<CampaignWithCurrencyConverted>(
    dslContextProvider
) {
    override fun getFields(): Collection<Field<*>> = mapper.fieldsToRead

    override fun <M : CampaignWithCurrencyConverted> fillFromRecord(model: M, record: Record) {
        mapper.fromDb(record, model)
    }

    override fun getTypeClass() = CampaignWithCurrencyConverted::class.java

    private companion object {
        private val mapper = JooqMapperBuilder.builder<CampaignWithCurrencyConverted>()
            .map(property(CampaignWithCurrencyConverted.ID, CAMPAIGNS.CID))
            .map(
                convertibleProperty(
                    CampaignWithCurrencyConverted.CURRENCY_CONVERTED,
                    CAMPAIGNS.CURRENCY_CONVERTED,
                    CampaignMappings::currencyConvertedFromDb,
                    CampaignMappings::currencyConvertedToDb
                )
            )
            .build()
    }
}
