package ru.yandex.direct.core.entity.campaign.repository.type;

import java.util.Collection;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.Field;
import org.jooq.Record;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithDisabledVideoPlacements;
import ru.yandex.direct.core.entity.campaign.repository.CampaignMappings;
import ru.yandex.direct.dbschema.ppc.tables.Campaigns;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.jooqmapper.JooqMapper;
import ru.yandex.direct.jooqmapper.JooqMapperBuilder;
import ru.yandex.direct.jooqmapperhelper.InsertHelperAggregator;
import ru.yandex.direct.jooqmapperhelper.UpdateHelperAggregator;
import ru.yandex.direct.model.AppliedChanges;

import static ru.yandex.direct.dbschema.ppc.Tables.CAMPAIGNS;
import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.convertibleProperty;
import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.property;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithDisabledVideoPlacementsRepositoryTypeSupport
        extends AbstractCampaignRepositoryTypeSupport<CampaignWithDisabledVideoPlacements> {
    private static final JooqMapper<CampaignWithDisabledVideoPlacements> MAPPER =
            createCampaignWithDisabledVideoPlacementsMapper();

    @Autowired
    CampaignWithDisabledVideoPlacementsRepositoryTypeSupport(DslContextProvider dslContextProvider) {
        super(dslContextProvider);
    }

    private static JooqMapper<CampaignWithDisabledVideoPlacements> createCampaignWithDisabledVideoPlacementsMapper() {
        return JooqMapperBuilder.<CampaignWithDisabledVideoPlacements>builder()
                .map(property(CampaignWithDisabledVideoPlacements.ID, CAMPAIGNS.CID))
                .map(convertibleProperty(CampaignWithDisabledVideoPlacements.DISABLED_VIDEO_PLACEMENTS,
                        Campaigns.CAMPAIGNS.DISABLED_VIDEO_PLACEMENTS,
                        CampaignMappings::disabledVideoPlacementsFromJson,
                        CampaignMappings::disabledVideoPlacementsToJson))
                .build();
    }

    @Override
    public void processUpdate(UpdateHelperAggregator updateHelperAggregator,
                              Collection<AppliedChanges<CampaignWithDisabledVideoPlacements>> appliedChanges) {
        updateHelperAggregator.getOrCreate(CAMPAIGNS.CID).processUpdateAll(MAPPER, appliedChanges);
    }

    @Override
    public void pushToInsert(InsertHelperAggregator insertHelperAggregator,
                             CampaignWithDisabledVideoPlacements campaign) {
        insertHelperAggregator.getOrCreate(CAMPAIGNS).add(MAPPER, campaign);
    }

    @Override
    public Collection<Field<?>> getFields() {
        return MAPPER.getFieldsToRead();
    }

    @Override
    public <M extends CampaignWithDisabledVideoPlacements> void fillFromRecord(M campaign, Record record) {
        MAPPER.fromDb(record, campaign);
    }

    @Override
    public Class<CampaignWithDisabledVideoPlacements> getTypeClass() {
        return CampaignWithDisabledVideoPlacements.class;
    }
}
