package ru.yandex.direct.core.entity.campaign.repository.type;
import java.util.Collection;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.Field;
import org.jooq.Record;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithDisallowedPageIds;
import ru.yandex.direct.core.entity.campaign.repository.CampaignMappings;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.jooqmapper.JooqMapper;
import ru.yandex.direct.jooqmapper.JooqMapperBuilder;
import ru.yandex.direct.jooqmapperhelper.InsertHelperAggregator;
import ru.yandex.direct.jooqmapperhelper.UpdateHelperAggregator;
import ru.yandex.direct.model.AppliedChanges;

import static ru.yandex.direct.dbschema.ppc.Tables.CAMP_OPTIONS;
import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.convertibleProperty;
import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.property;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithDisallowedPageIdsTypeSupport extends AbstractCampaignRepositoryTypeSupport<CampaignWithDisallowedPageIds> {
    private static final JooqMapper<CampaignWithDisallowedPageIds> MAPPER =
            createCampaignWithDisallowedPageIdsMapper();

    @Autowired
    CampaignWithDisallowedPageIdsTypeSupport(DslContextProvider dslContextProvider) {
        super(dslContextProvider);
    }

    @Override
    public void processUpdate(UpdateHelperAggregator updateHelperAggregator,
            Collection<AppliedChanges<CampaignWithDisallowedPageIds>> appliedChanges) {
        updateHelperAggregator.getOrCreate(CAMP_OPTIONS.CID)
                .processUpdateAll(MAPPER, appliedChanges);
    }

    @Override
    public void pushToInsert(InsertHelperAggregator insertHelperAggregator,
            CampaignWithDisallowedPageIds campaign) {
        insertHelperAggregator.getOrCreate(CAMP_OPTIONS).add(MAPPER, campaign);
    }

    @Override
    public Collection<Field<?>> getFields() {
        return MAPPER.getFieldsToRead();
    }

    @Override
    public <M extends CampaignWithDisallowedPageIds> void fillFromRecord(M campaign, Record record) {
        MAPPER.fromDb(record, campaign);
    }

    @Override
    public Class<CampaignWithDisallowedPageIds> getTypeClass() {
        return CampaignWithDisallowedPageIds.class;
    }

    private static JooqMapper<CampaignWithDisallowedPageIds> createCampaignWithDisallowedPageIdsMapper() {
        return JooqMapperBuilder.<CampaignWithDisallowedPageIds>builder()
                .map(property(CampaignWithDisallowedPageIds.ID, CAMP_OPTIONS.CID))
                .map(convertibleProperty(CampaignWithDisallowedPageIds.DISALLOWED_PAGE_IDS, CAMP_OPTIONS.DISALLOWED_PAGE_IDS,
                        CampaignMappings::pageIdsFromDbNullWhenEmpty, CampaignMappings::pageIdsToDb))

                .build();
    }
}

