package ru.yandex.direct.core.entity.campaign.repository.type;

import java.util.Collection;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.Field;
import org.jooq.Record;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.converter.EshowsSettingsConverter;
import ru.yandex.direct.core.entity.campaign.model.CampaignWithEshowsSettings;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.jooqmapper.JooqMapper;
import ru.yandex.direct.jooqmapper.JooqMapperBuilder;
import ru.yandex.direct.jooqmapperhelper.InsertHelperAggregator;
import ru.yandex.direct.jooqmapperhelper.UpdateHelperAggregator;
import ru.yandex.direct.model.AppliedChanges;

import static ru.yandex.direct.dbschema.ppc.Tables.CAMP_OPTIONS;
import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.property;
import static ru.yandex.direct.jooqmapper.read.ReaderBuilders.fromFields;
import static ru.yandex.direct.jooqmapper.write.WriterBuilders.fromProperty;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithEshowsSettingsSupport
        extends AbstractCampaignRepositoryTypeSupport<CampaignWithEshowsSettings> {
    private static final JooqMapper<CampaignWithEshowsSettings> MAPPER =
            JooqMapperBuilder.<CampaignWithEshowsSettings>builder()
                    .map(property(CampaignWithEshowsSettings.ID, CAMP_OPTIONS.CID))
                    .readProperty(CampaignWithEshowsSettings.ESHOWS_SETTINGS,
                            fromFields(CAMP_OPTIONS.ESHOWS_BANNER_RATE,
                                    CAMP_OPTIONS.ESHOWS_VIDEO_RATE,
                                    CAMP_OPTIONS.ESHOWS_VIDEO_TYPE)
                                    .by(EshowsSettingsConverter::fromDbFormat))
                    .writeField(CAMP_OPTIONS.ESHOWS_BANNER_RATE,
                            fromProperty(CampaignWithEshowsSettings.ESHOWS_SETTINGS)
                                    .by(EshowsSettingsConverter::bannerRateToDb))
                    .writeField(CAMP_OPTIONS.ESHOWS_VIDEO_RATE,
                            fromProperty(CampaignWithEshowsSettings.ESHOWS_SETTINGS)
                                    .by(EshowsSettingsConverter::videoRateToDb))
                    .writeField(CAMP_OPTIONS.ESHOWS_VIDEO_TYPE,
                            fromProperty(CampaignWithEshowsSettings.ESHOWS_SETTINGS)
                                    .by(EshowsSettingsConverter::videoTypeToDb))
                    .build();

    @Autowired
    public CampaignWithEshowsSettingsSupport(DslContextProvider dslContextProvider) {
        super(dslContextProvider);
    }

    @Override
    public Class<CampaignWithEshowsSettings> getTypeClass() {
        return CampaignWithEshowsSettings.class;
    }

    @Override
    public Collection<Field<?>> getFields() {
        return MAPPER.getFieldsToRead();
    }

    @Override
    public <M extends CampaignWithEshowsSettings> void fillFromRecord(M campaign, Record record) {
        MAPPER.fromDb(record, campaign);
    }

    @Override
    public void pushToInsert(InsertHelperAggregator insertHelperAggregator,
                             CampaignWithEshowsSettings campaign) {
        insertHelperAggregator.getOrCreate(CAMP_OPTIONS).add(MAPPER, campaign);
    }

    @Override
    public void processUpdate(UpdateHelperAggregator updateHelperAggregator,
                              Collection<AppliedChanges<CampaignWithEshowsSettings>> appliedChanges) {
        updateHelperAggregator.getOrCreate(CAMP_OPTIONS.CID).processUpdateAll(MAPPER, appliedChanges);
    }
}
