package ru.yandex.direct.core.entity.campaign.repository.type;

import java.util.Collection;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.Field;
import org.jooq.Record;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithExcludePausedCompetingAds;
import ru.yandex.direct.dbschema.ppc.enums.CampOptionsFairauction;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.jooqmapper.JooqMapper;
import ru.yandex.direct.jooqmapper.JooqMapperBuilder;
import ru.yandex.direct.jooqmapperhelper.InsertHelperAggregator;
import ru.yandex.direct.jooqmapperhelper.UpdateHelperAggregator;
import ru.yandex.direct.model.AppliedChanges;

import static ru.yandex.direct.common.jooqmapperex.ReaderWriterBuildersEx.booleanProperty;
import static ru.yandex.direct.dbschema.ppc.Tables.CAMP_OPTIONS;
import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.property;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithExcludePausedCompetingAdsTypeSupport extends
        AbstractCampaignRepositoryTypeSupport<CampaignWithExcludePausedCompetingAds> {
    private static final JooqMapper<CampaignWithExcludePausedCompetingAds> MAPPER =
            createCampaignWithAllowedPageIdsMapper();

    @Autowired
    CampaignWithExcludePausedCompetingAdsTypeSupport(DslContextProvider dslContextProvider) {
        super(dslContextProvider);
    }

    @Override
    public void processUpdate(UpdateHelperAggregator updateHelperAggregator,
                              Collection<AppliedChanges<CampaignWithExcludePausedCompetingAds>> appliedChanges) {
        updateHelperAggregator.getOrCreate(CAMP_OPTIONS.CID)
                .processUpdateAll(MAPPER, appliedChanges);
    }

    @Override
    public Collection<Field<?>> getFields() {
        return MAPPER.getFieldsToRead();
    }

    @Override
    public <M extends CampaignWithExcludePausedCompetingAds> void fillFromRecord(M campaign, Record record) {
        MAPPER.fromDb(record, campaign);
    }

    @Override
    public void pushToInsert(InsertHelperAggregator insertHelperAggregator,
                             CampaignWithExcludePausedCompetingAds campaign) {
        insertHelperAggregator.getOrCreate(CAMP_OPTIONS).add(MAPPER, campaign);
    }

    @Override
    public Class<CampaignWithExcludePausedCompetingAds> getTypeClass() {
        return CampaignWithExcludePausedCompetingAds.class;
    }

    private static JooqMapper<CampaignWithExcludePausedCompetingAds> createCampaignWithAllowedPageIdsMapper() {
        return JooqMapperBuilder.<CampaignWithExcludePausedCompetingAds>builder()
                .map(property(CampaignWithExcludePausedCompetingAds.ID, CAMP_OPTIONS.CID))
                .map(booleanProperty(CampaignWithExcludePausedCompetingAds.EXCLUDE_PAUSED_COMPETING_ADS,
                        CAMP_OPTIONS.FAIR_AUCTION, CampOptionsFairauction.class))
                .build();
    }
}
