package ru.yandex.direct.core.entity.campaign.repository.type;

import java.util.Collection;
import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.Field;
import org.jooq.JoinType;
import org.jooq.Record;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.common.util.RepositoryUtils;
import ru.yandex.direct.core.entity.campaign.model.CampaignWithFrontpageTypes;
import ru.yandex.direct.core.entity.currency.model.cpmyndxfrontpage.FrontpageCampaignShowType;
import ru.yandex.direct.dbschema.ppcdict.enums.CpmYndxFrontpageMinBidsFrontpageType;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.jooqmapper.JooqMapper;
import ru.yandex.direct.jooqmapper.JooqMapperBuilder;
import ru.yandex.direct.jooqmapper.write.WriterBuilders;
import ru.yandex.direct.jooqmapperhelper.InsertHelperAggregator;
import ru.yandex.direct.jooqmapperhelper.UpdateHelperAggregator;
import ru.yandex.direct.model.AppliedChanges;
import ru.yandex.direct.multitype.entity.JoinQuery;

import static ru.yandex.direct.dbschema.ppc.Tables.CAMPAIGNS;
import static ru.yandex.direct.dbschema.ppc.Tables.CAMPAIGNS_CPM_YNDX_FRONTPAGE;
import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.convertibleProperty;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithFrontpageTypesTypeSupport extends AbstractCampaignRepositoryTypeSupport<CampaignWithFrontpageTypes> {
    private static final JooqMapper<CampaignWithFrontpageTypes> MAPPER = createMapper();

    @Autowired
    public CampaignWithFrontpageTypesTypeSupport(DslContextProvider dslContextProvider) {
        super(dslContextProvider);
    }

    @Override
    public Class<CampaignWithFrontpageTypes> getTypeClass() {
        return CampaignWithFrontpageTypes.class;
    }

    @Override
    public Collection<Field<?>> getFields() {
        return MAPPER.getFieldsToRead();
    }

    @Override
    public List<JoinQuery> joinQuery() {
        return List.of(new JoinQuery(CAMPAIGNS_CPM_YNDX_FRONTPAGE, JoinType.LEFT_OUTER_JOIN,
                CAMPAIGNS_CPM_YNDX_FRONTPAGE.CID.eq(CAMPAIGNS.CID)));
    }

    @Override
    public void processUpdate(UpdateHelperAggregator updateHelperAggregator,
                              Collection<AppliedChanges<CampaignWithFrontpageTypes>> appliedChanges) {
        updateHelperAggregator.getOrCreate(CAMPAIGNS_CPM_YNDX_FRONTPAGE.CID).processUpdateAll(MAPPER, appliedChanges);
    }

    @Override
    public void pushToInsert(InsertHelperAggregator insertHelperAggregator,
                             CampaignWithFrontpageTypes campaign) {
        insertHelperAggregator.getOrCreate(CAMPAIGNS_CPM_YNDX_FRONTPAGE).add(MAPPER, campaign);
    }

    @Override
    public void fillFromRecord(CampaignWithFrontpageTypes campaign, Record record) {
        MAPPER.fromDb(record, campaign);
    }

    private static JooqMapper<CampaignWithFrontpageTypes> createMapper() {
        return JooqMapperBuilder.<CampaignWithFrontpageTypes>builder()
                .writeField(CAMPAIGNS_CPM_YNDX_FRONTPAGE.CID,
                        WriterBuilders.fromProperty(CampaignWithFrontpageTypes.ID))
                .map(convertibleProperty(CampaignWithFrontpageTypes.ALLOWED_FRONTPAGE_TYPE,
                        CAMPAIGNS_CPM_YNDX_FRONTPAGE.ALLOWED_FRONTPAGE_TYPES,
                        s -> RepositoryUtils.setFromDb(s,
                                e -> FrontpageCampaignShowType.fromSource(CpmYndxFrontpageMinBidsFrontpageType.valueOf(e))),
                        s -> RepositoryUtils.setToDb(s, t -> FrontpageCampaignShowType.toSource(t).getLiteral())
                ))
                .build();
    }

}
