package ru.yandex.direct.core.entity.campaign.repository.type;

import java.util.Collection;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.Field;
import org.jooq.Record;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithGeo;
import ru.yandex.direct.core.entity.campaign.repository.CampaignMappings;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.jooqmapper.JooqMapper;
import ru.yandex.direct.jooqmapper.JooqMapperBuilder;
import ru.yandex.direct.jooqmapperhelper.InsertHelperAggregator;
import ru.yandex.direct.jooqmapperhelper.UpdateHelperAggregator;
import ru.yandex.direct.model.AppliedChanges;

import static ru.yandex.direct.dbschema.ppc.Tables.CAMPAIGNS;
import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.convertibleProperty;
import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.property;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithGeoTypeSupport extends AbstractCampaignRepositoryTypeSupport<CampaignWithGeo> {
    private static final JooqMapper<CampaignWithGeo> MAPPER = createMapper();

    @Autowired
    public CampaignWithGeoTypeSupport(DslContextProvider dslContextProvider) {
        super(dslContextProvider);
    }

    @Override
    public Class<CampaignWithGeo> getTypeClass() {
        return CampaignWithGeo.class;
    }

    @Override
    public Collection<Field<?>> getFields() {
        return MAPPER.getFieldsToRead();
    }

    @Override
    public void processUpdate(UpdateHelperAggregator updateHelperAggregator,
                              Collection<AppliedChanges<CampaignWithGeo>> appliedChanges) {
        updateHelperAggregator.getOrCreate(CAMPAIGNS.CID).processUpdateAll(MAPPER, appliedChanges);
    }

    @Override
    public void pushToInsert(InsertHelperAggregator insertHelperAggregator,
                             CampaignWithGeo campaign) {
        insertHelperAggregator.getOrCreate(CAMPAIGNS).add(MAPPER, campaign);
    }

    @Override
    public void fillFromRecord(CampaignWithGeo campaign, Record record) {
        MAPPER.fromDb(record, campaign);
    }

    private static JooqMapper<CampaignWithGeo> createMapper() {
        return JooqMapperBuilder.<CampaignWithGeo>builder()
                .map(property(CampaignWithGeo.ID, CAMPAIGNS.CID))
                .map(convertibleProperty(CampaignWithGeo.GEO, CAMPAIGNS.GEO,
                        CampaignMappings::geoFromDb,
                        CampaignMappings::geoToDb))
                .build();
    }

}
