package ru.yandex.direct.core.entity.campaign.repository.type;

import java.util.Collection;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.Field;
import org.jooq.Record;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithImpressionRate;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.jooqmapper.JooqMapper;
import ru.yandex.direct.jooqmapper.JooqMapperBuilder;
import ru.yandex.direct.jooqmapperhelper.InsertHelperAggregator;
import ru.yandex.direct.jooqmapperhelper.UpdateHelperAggregator;
import ru.yandex.direct.model.AppliedChanges;

import static ru.yandex.direct.common.util.RepositoryUtils.intFromLong;
import static ru.yandex.direct.common.util.RepositoryUtils.zeroToNull;
import static ru.yandex.direct.dbschema.ppc.Tables.CAMPAIGNS;
import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.convertibleProperty;
import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.property;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithImpressionRateTypeSupport
        extends AbstractCampaignRepositoryTypeSupport<CampaignWithImpressionRate> {
    private static final JooqMapper<CampaignWithImpressionRate> MAPPER =
            JooqMapperBuilder.<CampaignWithImpressionRate>builder()
                    .map(property(CampaignWithImpressionRate.ID, CAMPAIGNS.CID))
                    .map(convertibleProperty(CampaignWithImpressionRate.IMPRESSION_RATE_COUNT, CAMPAIGNS.RF,
                            CampaignWithImpressionRateTypeSupport::fromDb,
                            CampaignWithImpressionRateTypeSupport::toDb))
                    .map(convertibleProperty(
                            CampaignWithImpressionRate.IMPRESSION_RATE_INTERVAL_DAYS, CAMPAIGNS.RF_RESET,
                            CampaignWithImpressionRateTypeSupport::fromDb,
                            CampaignWithImpressionRateTypeSupport::toDb))
                    .build();

    @Autowired
    public CampaignWithImpressionRateTypeSupport(DslContextProvider dslContextProvider) {
        super(dslContextProvider);
    }

    @Override
    public Class<CampaignWithImpressionRate> getTypeClass() {
        return CampaignWithImpressionRate.class;
    }

    @Override
    public Collection<Field<?>> getFields() {
        return MAPPER.getFieldsToRead();
    }

    @Override
    public <M extends CampaignWithImpressionRate> void fillFromRecord(M campaign, Record record) {
        MAPPER.fromDb(record, campaign);
    }

    @Override
    public void processUpdate(UpdateHelperAggregator updateHelperAggregator,
                              Collection<AppliedChanges<CampaignWithImpressionRate>> appliedChanges) {
        updateHelperAggregator.getOrCreate(CAMPAIGNS.CID).processUpdateAll(MAPPER, appliedChanges);
    }

    @Override
    public void pushToInsert(InsertHelperAggregator insertHelperAggregator, CampaignWithImpressionRate campaign) {
        insertHelperAggregator.getOrCreate(CAMPAIGNS).add(MAPPER, campaign);
    }

    private static Integer fromDb(@Nullable Long dbValue) {
        return zeroToNull(intFromLong(dbValue));
    }

    private static Long toDb(@Nullable Integer modelValue) {
        return modelValue != null && modelValue != 0 ? modelValue.longValue() : 0L;
    }
}
