package ru.yandex.direct.core.entity.campaign.repository.type;

import java.util.Collection;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.Field;
import org.jooq.Record;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.converter.ImpressionStandardTimeConverter;
import ru.yandex.direct.core.entity.campaign.model.CampaignWithImpressionStandardTime;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.jooqmapper.JooqMapper;
import ru.yandex.direct.jooqmapper.JooqMapperBuilder;
import ru.yandex.direct.jooqmapperhelper.InsertHelperAggregator;

import static ru.yandex.direct.dbschema.ppc.Tables.CAMP_OPTIONS;
import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.property;
import static ru.yandex.direct.jooqmapper.read.ReaderBuilders.fromField;
import static ru.yandex.direct.jooqmapper.write.WriterBuilders.fromProperty;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithImpressionStandardTimeTypeSupport
        extends AbstractCampaignRepositoryTypeSupport<CampaignWithImpressionStandardTime> {
    private static final JooqMapper<CampaignWithImpressionStandardTime> MAPPER =
            JooqMapperBuilder.<CampaignWithImpressionStandardTime>builder()
                    .map(property(CampaignWithImpressionStandardTime.ID, CAMP_OPTIONS.CID))
                    .readProperty(CampaignWithImpressionStandardTime.IMPRESSION_STANDARD_TIME,
                            fromField(CAMP_OPTIONS.IMPRESSION_STANDARD_TIME)
                                    .by(ImpressionStandardTimeConverter::fromDbFormat))
                    .writeField(CAMP_OPTIONS.IMPRESSION_STANDARD_TIME,
                            fromProperty(CampaignWithImpressionStandardTime.IMPRESSION_STANDARD_TIME)
                                    .by(ImpressionStandardTimeConverter::toDbFormat))
                    .build();

    @Autowired
    public CampaignWithImpressionStandardTimeTypeSupport(DslContextProvider dslContextProvider) {
        super(dslContextProvider);
    }

    @Override
    public Class<CampaignWithImpressionStandardTime> getTypeClass() {
        return CampaignWithImpressionStandardTime.class;
    }

    @Override
    public Collection<Field<?>> getFields() {
        return MAPPER.getFieldsToRead();
    }

    @Override
    public <M extends CampaignWithImpressionStandardTime> void fillFromRecord(M campaign, Record record) {
        MAPPER.fromDb(record, campaign);
    }

    @Override
    public void pushToInsert(InsertHelperAggregator insertHelperAggregator,
                             CampaignWithImpressionStandardTime campaign) {
        insertHelperAggregator.getOrCreate(CAMP_OPTIONS).add(MAPPER, campaign);
    }
}
