package ru.yandex.direct.core.entity.campaign.repository.type;

import java.util.Collection;
import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.JoinType;
import org.jooq.Record;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithMasterCampaign;
import ru.yandex.direct.core.entity.campaign.service.type.add.container.RestrictedCampaignsAddOperationContainer;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.jooqmapper.JooqMapper;
import ru.yandex.direct.jooqmapper.JooqMapperBuilder;
import ru.yandex.direct.jooqmapperhelper.InsertHelper;
import ru.yandex.direct.multitype.entity.JoinQuery;

import static ru.yandex.direct.dbschema.ppc.Tables.CAMPAIGNS;
import static ru.yandex.direct.dbschema.ppc.Tables.SUBCAMPAIGNS;
import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.property;
import static ru.yandex.direct.utils.FunctionalUtils.filterList;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithMasterCampaignTypeSupport extends AbstractCampaignRepositoryTypeSupport<CampaignWithMasterCampaign> {
    private static final JooqMapper<CampaignWithMasterCampaign> MAPPER = createMapper();

    @Autowired
    CampaignWithMasterCampaignTypeSupport(DslContextProvider dslContextProvider) {
        super(dslContextProvider);
    }

    private static JooqMapper<CampaignWithMasterCampaign> createMapper() {
        return JooqMapperBuilder.<CampaignWithMasterCampaign>builder()
                .map(property(CampaignWithMasterCampaign.ID, SUBCAMPAIGNS.CID))
                .map(property(CampaignWithMasterCampaign.MASTER_CID, SUBCAMPAIGNS.MASTER_CID))
                .build();
    }

    @Override
    public Collection<Field<?>> getFields() {
        return MAPPER.getFieldsToRead();
    }

    @Override
    public List<JoinQuery> joinQuery() {
        return List.of(new JoinQuery(SUBCAMPAIGNS,
                JoinType.LEFT_OUTER_JOIN,
                SUBCAMPAIGNS.CID.eq(CAMPAIGNS.CID)));
    }

    @Override
    public void insertToAdditionTables(DSLContext context,
                                       RestrictedCampaignsAddOperationContainer addModelParametersContainer,
                                       Collection<CampaignWithMasterCampaign> models) {
        List<CampaignWithMasterCampaign> campaignsToInsert =
                filterList(models, campaign -> campaign.getMasterCid() != null);
        new InsertHelper<>(context, SUBCAMPAIGNS)
                .addAll(MAPPER, campaignsToInsert)
                .executeIfRecordsAdded();
    }

    @Override
    public <M extends CampaignWithMasterCampaign> void fillFromRecord(M campaign, Record record) {
        MAPPER.fromDb(record, campaign);
    }

    @Override
    public Class<CampaignWithMasterCampaign> getTypeClass() {
        return CampaignWithMasterCampaign.class;
    }
}
