package ru.yandex.direct.core.entity.campaign.repository.type;

import java.util.Collection;
import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.Field;
import org.jooq.JoinType;
import org.jooq.Record;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithMetrikaCounters;
import ru.yandex.direct.core.entity.campaign.repository.CampaignMappings;
import ru.yandex.direct.dbschema.ppc.Tables;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.jooqmapper.JooqMapper;
import ru.yandex.direct.jooqmapper.JooqMapperBuilder;
import ru.yandex.direct.multitype.entity.JoinQuery;

import static ru.yandex.direct.dbschema.ppc.Tables.CAMP_METRIKA_COUNTERS;
import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.convertibleProperty;
import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.property;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithMetrikaCountersTypeSupport extends AbstractCampaignRepositoryTypeSupport<CampaignWithMetrikaCounters> {

    private static final JooqMapper<CampaignWithMetrikaCounters> MAPPER = createCampaignWithMetrikaCountersMapper();

    @Autowired
    public CampaignWithMetrikaCountersTypeSupport(DslContextProvider dslContextProvider) {
        super(dslContextProvider);
    }

    @Override
    public Class<CampaignWithMetrikaCounters> getTypeClass() {
        return CampaignWithMetrikaCounters.class;
    }

    @Override
    public Collection<Field<?>> getFields() {
        return MAPPER.getFieldsToRead();
    }

    @Override
    public List<JoinQuery> joinQuery() {
        return List.of(new JoinQuery(CAMP_METRIKA_COUNTERS, JoinType.LEFT_OUTER_JOIN,
                CAMP_METRIKA_COUNTERS.CID.eq(Tables.CAMPAIGNS.CID)));
    }

    @Override
    public void fillFromRecord(CampaignWithMetrikaCounters campaign, Record record) {
        MAPPER.fromDb(record, campaign);
    }

    private static JooqMapper<CampaignWithMetrikaCounters> createCampaignWithMetrikaCountersMapper() {
        return JooqMapperBuilder.<CampaignWithMetrikaCounters>builder()
                .map(property(CampaignWithMetrikaCounters.ID, CAMP_METRIKA_COUNTERS.CID))
                // NB: этот класс не пишет CAMP_METRIKA_COUNTERS.METRIKA_COUNTERS, т.к. не реализован метод pushToInsert
                // Запись metrikaCounters в базу происходит в CampaignWithMetrikaCountersUpdateOperationSupport
                .map(convertibleProperty(CampaignWithMetrikaCounters.METRIKA_COUNTERS,
                        CAMP_METRIKA_COUNTERS.METRIKA_COUNTERS,
                        CampaignMappings::metrikaCountersFromDbToListOfCounters, CampaignMappings::metrikaCountersToDb))
                .build();
    }

}
