package ru.yandex.direct.core.entity.campaign.repository.type;

import java.util.Collection;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.Field;
import org.jooq.Record;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithMinusKeywords;
import ru.yandex.direct.core.entity.minuskeywordspack.MinusKeywordsPackUtils;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.jooqmapper.JooqMapper;
import ru.yandex.direct.jooqmapper.JooqMapperBuilder;
import ru.yandex.direct.jooqmapperhelper.InsertHelperAggregator;
import ru.yandex.direct.jooqmapperhelper.UpdateHelperAggregator;
import ru.yandex.direct.model.AppliedChanges;

import static ru.yandex.direct.dbschema.ppc.Tables.CAMP_OPTIONS;
import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.convertibleProperty;
import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.property;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithMinusKeywordsTypeSupport extends AbstractCampaignRepositoryTypeSupport<CampaignWithMinusKeywords> {
    private static final JooqMapper<CampaignWithMinusKeywords> MAPPER = createMapper();

    @Autowired
    CampaignWithMinusKeywordsTypeSupport(DslContextProvider dslContextProvider) {
        super(dslContextProvider);
    }

    @Override
    public Collection<Field<?>> getFields() {
        return MAPPER.getFieldsToRead();
    }

    @Override
    public <M extends CampaignWithMinusKeywords> void fillFromRecord(M campaign, Record record) {
        MAPPER.fromDb(record, campaign);
    }

    @Override
    public void processUpdate(UpdateHelperAggregator updateHelperAggregator,
                              Collection<AppliedChanges<CampaignWithMinusKeywords>> appliedChanges) {
        updateHelperAggregator.getOrCreate(CAMP_OPTIONS.CID).processUpdateAll(MAPPER, appliedChanges);
    }

    @Override
    public void pushToInsert(InsertHelperAggregator insertHelperAggregator, CampaignWithMinusKeywords campaign) {
        insertHelperAggregator.getOrCreate(CAMP_OPTIONS).add(MAPPER, campaign);
    }

    @Override
    public Class<CampaignWithMinusKeywords> getTypeClass() {
        return CampaignWithMinusKeywords.class;
    }

    private static JooqMapper<CampaignWithMinusKeywords> createMapper() {
        return JooqMapperBuilder.<CampaignWithMinusKeywords>builder()
                .map(property(CampaignWithMinusKeywords.ID, CAMP_OPTIONS.CID))
                .map(convertibleProperty(CampaignWithMinusKeywords.MINUS_KEYWORDS, CAMP_OPTIONS.MINUS_WORDS,
                        MinusKeywordsPackUtils::minusKeywordsFromJson,
                        MinusKeywordsPackUtils::minusKeywordsToJson))
                .build();
    }
}
