package ru.yandex.direct.core.entity.campaign.repository.type;

import java.util.Collection;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.Field;
import org.jooq.Record;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithNetworkSettings;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.jooqmapper.JooqMapper;
import ru.yandex.direct.jooqmapper.JooqMapperBuilder;
import ru.yandex.direct.jooqmapperhelper.InsertHelperAggregator;
import ru.yandex.direct.jooqmapperhelper.UpdateHelperAggregator;
import ru.yandex.direct.model.AppliedChanges;

import static ru.yandex.direct.dbschema.ppc.Tables.CAMPAIGNS;
import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.convertibleProperty;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithNetworkSettingsTypeSupport extends AbstractCampaignRepositoryTypeSupport<CampaignWithNetworkSettings> {

    private static final JooqMapper<CampaignWithNetworkSettings> MAPPER = createMapper();

    @Autowired
    public CampaignWithNetworkSettingsTypeSupport(DslContextProvider dslContextProvider) {
        super(dslContextProvider);
    }

    @Override
    public Class<CampaignWithNetworkSettings> getTypeClass() {
        return CampaignWithNetworkSettings.class;
    }

    @Override
    public Collection<Field<?>> getFields() {
        return MAPPER.getFieldsToRead();
    }

    @Override
    public void processUpdate(UpdateHelperAggregator updateHelperAggregator,
                              Collection<AppliedChanges<CampaignWithNetworkSettings>> appliedChanges) {
        updateHelperAggregator.getOrCreate(CAMPAIGNS.CID).processUpdateAll(MAPPER, appliedChanges);
    }

    @Override
    public void pushToInsert(InsertHelperAggregator insertHelperAggregator, CampaignWithNetworkSettings campaign) {
        insertHelperAggregator.getOrCreate(CAMPAIGNS).add(MAPPER, campaign);
    }

    @Override
    public void fillFromRecord(CampaignWithNetworkSettings campaign, Record record) {
        MAPPER.fromDb(record, campaign);
    }

    private static JooqMapper<CampaignWithNetworkSettings> createMapper() {
        return JooqMapperBuilder.<CampaignWithNetworkSettings>builder()
                .map(convertibleProperty(CampaignWithNetworkSettings.CONTEXT_LIMIT,
                        CAMPAIGNS.CONTEXT_LIMIT, Long::intValue, Integer::longValue))
                .map(convertibleProperty(CampaignWithNetworkSettings.CONTEXT_PRICE_COEF,
                        CAMPAIGNS.CONTEXT_PRICE_COEF, Long::intValue, Integer::longValue))
                .build();
    }

}
