package ru.yandex.direct.core.entity.campaign.repository.type;

import java.util.Collection;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.Field;
import org.jooq.Record;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.converter.CampaignConverter;
import ru.yandex.direct.core.entity.campaign.model.CampaignWithNewIosVersion;
import ru.yandex.direct.core.entity.campaign.model.CommonCampaign;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.jooqmapper.read.JooqReader;
import ru.yandex.direct.jooqmapper.read.JooqReaderBuilder;

import static ru.yandex.direct.dbschema.ppc.tables.Campaigns.CAMPAIGNS;
import static ru.yandex.direct.jooqmapper.read.ReaderBuilders.fromField;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithNewIosVersionTypeSupport
        extends AbstractCampaignRepositoryTypeSupport<CampaignWithNewIosVersion> {

    private static final JooqReader<CampaignWithNewIosVersion> READER = createReader();

    @Autowired
    public CampaignWithNewIosVersionTypeSupport(DslContextProvider dslContextProvider) {
        super(dslContextProvider);
    }

    @Override
    public Collection<Field<?>> getFields() {
        return READER.getFieldsToRead();
    }

    @Override
    public void fillFromRecord(CampaignWithNewIosVersion model, Record record) {
        READER.fromDb(record, model);
    }

    @Override
    public Class<CampaignWithNewIosVersion> getTypeClass() {
        return CampaignWithNewIosVersion.class;
    }

    private static JooqReader<CampaignWithNewIosVersion> createReader() {
        return JooqReaderBuilder.<CampaignWithNewIosVersion>builder()
                .readProperty(CommonCampaign.IS_NEW_IOS_VERSION_ENABLED, fromField(CAMPAIGNS.OPTS).by(
                        CampaignConverter::isNewIosVersionEnabled))
                .build();
    }
}
