package ru.yandex.direct.core.entity.campaign.repository.type;

import java.util.Collection;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.Field;
import org.jooq.Record;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithOfflineStatNoticeEvent;
import ru.yandex.direct.dbschema.ppc.enums.CampOptionsOfflinestatnotice;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.jooqmapper.JooqMapper;
import ru.yandex.direct.jooqmapper.JooqMapperBuilder;
import ru.yandex.direct.jooqmapperhelper.InsertHelperAggregator;
import ru.yandex.direct.jooqmapperhelper.UpdateHelperAggregator;
import ru.yandex.direct.model.AppliedChanges;

import static ru.yandex.direct.common.jooqmapperex.ReaderWriterBuildersEx.booleanProperty;
import static ru.yandex.direct.dbschema.ppc.Tables.CAMP_OPTIONS;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithOfflineStatNoticeEventTypeSupport extends AbstractCampaignRepositoryTypeSupport<CampaignWithOfflineStatNoticeEvent> {

    private static final JooqMapper<CampaignWithOfflineStatNoticeEvent> MAPPER = createMapper();

    @Autowired
    public CampaignWithOfflineStatNoticeEventTypeSupport(DslContextProvider dslContextProvider) {
        super(dslContextProvider);
    }

    @Override
    public Class<CampaignWithOfflineStatNoticeEvent> getTypeClass() {
        return CampaignWithOfflineStatNoticeEvent.class;
    }

    @Override
    public Collection<Field<?>> getFields() {
        return MAPPER.getFieldsToRead();
    }


    @Override
    public void processUpdate(UpdateHelperAggregator updateHelperAggregator,
                              Collection<AppliedChanges<CampaignWithOfflineStatNoticeEvent>> appliedChanges) {
        updateHelperAggregator.getOrCreate(CAMP_OPTIONS.CID).processUpdateAll(MAPPER, appliedChanges);
    }

    @Override
    public void pushToInsert(InsertHelperAggregator insertHelperAggregator,
                             CampaignWithOfflineStatNoticeEvent campaign) {
        insertHelperAggregator.getOrCreate(CAMP_OPTIONS).add(MAPPER, campaign);
    }

    @Override
    public void fillFromRecord(CampaignWithOfflineStatNoticeEvent campaign, Record record) {
        MAPPER.fromDb(record, campaign);
    }

    private static JooqMapper<CampaignWithOfflineStatNoticeEvent> createMapper() {
        return JooqMapperBuilder.<CampaignWithOfflineStatNoticeEvent>builder()
                .map(booleanProperty(CampaignWithOfflineStatNoticeEvent.ENABLE_OFFLINE_STAT_NOTICE,
                        CAMP_OPTIONS.OFFLINE_STAT_NOTICE,
                        CampOptionsOfflinestatnotice.class))
                .build();
    }

}
