package ru.yandex.direct.core.entity.campaign.repository.type;

import java.util.Collection;
import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.Field;
import org.jooq.JoinType;
import org.jooq.Record;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.converter.CampaignConverter;
import ru.yandex.direct.core.entity.campaign.model.CampaignWithOptimizingBy;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.jooqmapper.JooqMapper;
import ru.yandex.direct.jooqmapper.JooqMapperBuilder;
import ru.yandex.direct.jooqmapperhelper.InsertHelperAggregator;
import ru.yandex.direct.multitype.entity.JoinQuery;

import static ru.yandex.direct.dbschema.ppc.Tables.CAMPAIGNS;
import static ru.yandex.direct.dbschema.ppc.Tables.CAMPAIGNS_PERFORMANCE;
import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.convertibleProperty;
import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.property;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithOptimizingByTypeSupport extends AbstractCampaignRepositoryTypeSupport<CampaignWithOptimizingBy> {

    private static final JooqMapper<CampaignWithOptimizingBy> MAPPER = createMapper();

    @Autowired
    public CampaignWithOptimizingByTypeSupport(DslContextProvider dslContextProvider) {
        super(dslContextProvider);
    }

    @Override
    public Class<CampaignWithOptimizingBy> getTypeClass() {
        return CampaignWithOptimizingBy.class;
    }

    @Override
    public Collection<Field<?>> getFields() {
        return MAPPER.getFieldsToRead();
    }

    @Override
    public List<JoinQuery> joinQuery() {
        return List.of(new JoinQuery(CAMPAIGNS_PERFORMANCE, JoinType.LEFT_OUTER_JOIN,
                CAMPAIGNS_PERFORMANCE.CID.eq(CAMPAIGNS.CID)));
    }

    @Override
    public void pushToInsert(InsertHelperAggregator insertHelperAggregator, CampaignWithOptimizingBy campaign) {
        insertHelperAggregator.getOrCreate(CAMPAIGNS_PERFORMANCE).add(MAPPER, campaign);
    }

    @Override
    public void fillFromRecord(CampaignWithOptimizingBy campaign, Record record) {
        MAPPER.fromDb(record, campaign);
    }

    private static JooqMapper<CampaignWithOptimizingBy> createMapper() {
        return JooqMapperBuilder.<CampaignWithOptimizingBy>builder()
                .map(property(CampaignWithOptimizingBy.ID, CAMPAIGNS_PERFORMANCE.CID))
                .map(convertibleProperty(CampaignWithOptimizingBy.NOW_OPTIMIZING_BY,
                        CAMPAIGNS_PERFORMANCE.NOW_OPTIMIZING_BY,
                        CampaignConverter::optimizingByFromDbFormat, CampaignConverter::optimizingByToDbFormat))
                .build();
    }
}
