package ru.yandex.direct.core.entity.campaign.repository.type;

import java.util.Collection;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.Field;
import org.jooq.Record;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithOptionalAddMetrikaTagToUrl;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.jooqmapper.JooqMapper;
import ru.yandex.direct.jooqmapper.JooqMapperBuilder;
import ru.yandex.direct.jooqmapperhelper.InsertHelperAggregator;
import ru.yandex.direct.jooqmapperhelper.UpdateHelperAggregator;
import ru.yandex.direct.model.AppliedChanges;

import static ru.yandex.direct.common.jooqmapperex.ReaderWriterBuildersEx.booleanProperty;
import static ru.yandex.direct.dbschema.ppc.Tables.CAMP_OPTIONS;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithOptionalAddMetrikaTagToUrlTypeSupport extends AbstractCampaignRepositoryTypeSupport<CampaignWithOptionalAddMetrikaTagToUrl> {

    private static final JooqMapper<CampaignWithOptionalAddMetrikaTagToUrl> MAPPER = createMapper();

    @Autowired
    public CampaignWithOptionalAddMetrikaTagToUrlTypeSupport(DslContextProvider dslContextProvider) {
        super(dslContextProvider);
    }

    @Override
    public Class<CampaignWithOptionalAddMetrikaTagToUrl> getTypeClass() {
        return CampaignWithOptionalAddMetrikaTagToUrl.class;
    }

    @Override
    public Collection<Field<?>> getFields() {
        return MAPPER.getFieldsToRead();
    }

    @Override
    public void processUpdate(UpdateHelperAggregator updateHelperAggregator,
                              Collection<AppliedChanges<CampaignWithOptionalAddMetrikaTagToUrl>> appliedChanges) {
        updateHelperAggregator.getOrCreate(CAMP_OPTIONS.CID).processUpdateAll(MAPPER, appliedChanges);
    }

    @Override
    public void pushToInsert(InsertHelperAggregator insertHelperAggregator,
                             CampaignWithOptionalAddMetrikaTagToUrl campaign) {
        insertHelperAggregator.getOrCreate(CAMP_OPTIONS).add(MAPPER, campaign);
    }

    @Override
    public void fillFromRecord(CampaignWithOptionalAddMetrikaTagToUrl campaign, Record record) {
        MAPPER.fromDb(record, campaign);
    }

    private static JooqMapper<CampaignWithOptionalAddMetrikaTagToUrl> createMapper() {
        return JooqMapperBuilder.<CampaignWithOptionalAddMetrikaTagToUrl>builder()
                .map(booleanProperty(CampaignWithOptionalAddMetrikaTagToUrl.HAS_ADD_METRIKA_TAG_TO_URL,
                        CAMP_OPTIONS.STATUS_CLICK_TRACK))
                .build();
    }
}
