package ru.yandex.direct.core.entity.campaign.repository.type;

import java.util.Collection;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.Field;
import org.jooq.Record;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithOptionalAddOpenstatTagToUrl;
import ru.yandex.direct.dbschema.ppc.enums.CampaignsStatusopenstat;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.jooqmapper.JooqMapper;
import ru.yandex.direct.jooqmapper.JooqMapperBuilder;
import ru.yandex.direct.jooqmapperhelper.InsertHelperAggregator;
import ru.yandex.direct.jooqmapperhelper.UpdateHelperAggregator;
import ru.yandex.direct.model.AppliedChanges;

import static ru.yandex.direct.common.jooqmapperex.ReaderWriterBuildersEx.booleanProperty;
import static ru.yandex.direct.dbschema.ppc.Tables.CAMPAIGNS;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithOptionalAddOpenstatTagToUrlTypeSupport extends AbstractCampaignRepositoryTypeSupport<CampaignWithOptionalAddOpenstatTagToUrl> {

    private static final JooqMapper<CampaignWithOptionalAddOpenstatTagToUrl> MAPPER = createMapper();

    @Autowired
    public CampaignWithOptionalAddOpenstatTagToUrlTypeSupport(DslContextProvider dslContextProvider) {
        super(dslContextProvider);
    }

    @Override
    public Class<CampaignWithOptionalAddOpenstatTagToUrl> getTypeClass() {
        return CampaignWithOptionalAddOpenstatTagToUrl.class;
    }

    @Override
    public Collection<Field<?>> getFields() {
        return MAPPER.getFieldsToRead();
    }

    @Override
    public void processUpdate(UpdateHelperAggregator updateHelperAggregator,
                              Collection<AppliedChanges<CampaignWithOptionalAddOpenstatTagToUrl>> appliedChanges) {
        updateHelperAggregator.getOrCreate(CAMPAIGNS.CID).processUpdateAll(MAPPER, appliedChanges);
    }

    @Override
    public void pushToInsert(InsertHelperAggregator insertHelperAggregator,
                             CampaignWithOptionalAddOpenstatTagToUrl campaign) {
        insertHelperAggregator.getOrCreate(CAMPAIGNS).add(MAPPER, campaign);
    }

    @Override
    public void fillFromRecord(CampaignWithOptionalAddOpenstatTagToUrl campaign, Record record) {
        MAPPER.fromDb(record, campaign);
    }

    private static JooqMapper<CampaignWithOptionalAddOpenstatTagToUrl> createMapper() {
        return JooqMapperBuilder.<CampaignWithOptionalAddOpenstatTagToUrl>builder()
                .map(booleanProperty(CampaignWithOptionalAddOpenstatTagToUrl.HAS_ADD_OPENSTAT_TAG_TO_URL,
                        CAMPAIGNS.STATUS_OPEN_STAT,
                        CampaignsStatusopenstat.class))
                .build();
    }

}

