package ru.yandex.direct.core.entity.campaign.repository.type;

import java.util.Collection;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.Field;
import org.jooq.Record;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.converter.CampaignConverter;
import ru.yandex.direct.core.entity.campaign.model.CampaignWithOptionalAloneTrafaret;
import ru.yandex.direct.core.entity.campaign.model.CommonCampaign;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.jooqmapper.read.JooqReader;
import ru.yandex.direct.jooqmapper.read.JooqReaderBuilder;

import static ru.yandex.direct.dbschema.ppc.tables.Campaigns.CAMPAIGNS;
import static ru.yandex.direct.jooqmapper.read.ReaderBuilders.fromField;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithOptionalAloneTrafaretTypeSupport extends
        AbstractCampaignRepositoryTypeSupport<CampaignWithOptionalAloneTrafaret> {

    private static final JooqReader<CampaignWithOptionalAloneTrafaret> READER = createReader();

    @Autowired
    public CampaignWithOptionalAloneTrafaretTypeSupport(DslContextProvider dslContextProvider) {
        super(dslContextProvider);
    }

    @Override
    public Class<CampaignWithOptionalAloneTrafaret> getTypeClass() {
        return CampaignWithOptionalAloneTrafaret.class;
    }

    @Override
    public Collection<Field<?>> getFields() {
        return READER.getFieldsToRead();
    }

    @Override
    public void fillFromRecord(CampaignWithOptionalAloneTrafaret campaign, Record record) {
        READER.fromDb(record, campaign);
    }

    private static JooqReader<CampaignWithOptionalAloneTrafaret> createReader() {
        return JooqReaderBuilder.<CampaignWithOptionalAloneTrafaret>builder()
                .readProperty(CommonCampaign.IS_ALONE_TRAFARET_ALLOWED,
                        fromField(CAMPAIGNS.OPTS).by(CampaignConverter::isAloneTrafaretAllowedFromDb))
                .build();
    }
}
