package ru.yandex.direct.core.entity.campaign.repository.type;

import java.util.Collection;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.Field;
import org.jooq.Record;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.converter.CampaignConverter;
import ru.yandex.direct.core.entity.campaign.model.CampaignWithOptionalHasTurboSmarts;
import ru.yandex.direct.core.entity.campaign.model.CommonCampaign;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.jooqmapper.read.JooqReader;
import ru.yandex.direct.jooqmapper.read.JooqReaderBuilder;

import static ru.yandex.direct.dbschema.ppc.tables.Campaigns.CAMPAIGNS;
import static ru.yandex.direct.jooqmapper.read.ReaderBuilders.fromField;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithOptionalHasTurboSmartsTypeSupport extends
        AbstractCampaignRepositoryTypeSupport<CampaignWithOptionalHasTurboSmarts> {

    private static final JooqReader<CampaignWithOptionalHasTurboSmarts> READER = createReader();

    @Autowired
    public CampaignWithOptionalHasTurboSmartsTypeSupport(DslContextProvider dslContextProvider) {
        super(dslContextProvider);
    }

    @Override
    public Class<CampaignWithOptionalHasTurboSmarts> getTypeClass() {
        return CampaignWithOptionalHasTurboSmarts.class;
    }

    @Override
    public Collection<Field<?>> getFields() {
        return READER.getFieldsToRead();
    }

    @Override
    public void fillFromRecord(CampaignWithOptionalHasTurboSmarts campaign, Record record) {
        READER.fromDb(record, campaign);
    }

    private static JooqReader<CampaignWithOptionalHasTurboSmarts> createReader() {
        return JooqReaderBuilder.<CampaignWithOptionalHasTurboSmarts>builder()
                .readProperty(CommonCampaign.HAS_TURBO_SMARTS,
                        fromField(CAMPAIGNS.OPTS).by(CampaignConverter::hasTurboSmarts))
                .build();
    }
}
