package ru.yandex.direct.core.entity.campaign.repository.type;

import java.util.Collection;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.Field;
import org.jooq.Record;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.converter.CampaignConverter;
import ru.yandex.direct.core.entity.campaign.model.CampaignWithOptionalS2sTracking;
import ru.yandex.direct.core.entity.campaign.model.CommonCampaign;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.jooqmapper.read.JooqReader;
import ru.yandex.direct.jooqmapper.read.JooqReaderBuilder;

import static ru.yandex.direct.dbschema.ppc.tables.Campaigns.CAMPAIGNS;
import static ru.yandex.direct.jooqmapper.read.ReaderBuilders.fromField;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithOptionalIsS2sTrackingEnabledTypeSupport extends AbstractCampaignRepositoryTypeSupport<CampaignWithOptionalS2sTracking> {

    private static final JooqReader<CampaignWithOptionalS2sTracking> READER = createReader();

    @Autowired
    public CampaignWithOptionalIsS2sTrackingEnabledTypeSupport(DslContextProvider dslContextProvider) {
        super(dslContextProvider);
    }

    @Override
    public Collection<Field<?>> getFields() {
        return READER.getFieldsToRead();
    }

    @Override
    public void fillFromRecord(CampaignWithOptionalS2sTracking model, Record record) {
        READER.fromDb(record, model);
    }

    @Override
    public Class<CampaignWithOptionalS2sTracking> getTypeClass() {
        return CampaignWithOptionalS2sTracking.class;
    }

    private static JooqReader<CampaignWithOptionalS2sTracking> createReader() {
        return JooqReaderBuilder.<CampaignWithOptionalS2sTracking>builder()
                .readProperty(CommonCampaign.IS_S2S_TRACKING_ENABLED,
                        fromField(CAMPAIGNS.OPTS).by(CampaignConverter::isS2sTrackingEnabled))
                .build();
    }

}
