package ru.yandex.direct.core.entity.campaign.repository.type;

import java.util.Collection;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.Field;
import org.jooq.Record;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.converter.CampaignConverter;
import ru.yandex.direct.core.entity.campaign.model.CampaignWithOptionalMeaningfulGoalsValuesFromMetrika;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.jooqmapper.read.JooqReader;
import ru.yandex.direct.jooqmapper.read.JooqReaderBuilder;

import static ru.yandex.direct.dbschema.ppc.tables.Campaigns.CAMPAIGNS;
import static ru.yandex.direct.jooqmapper.read.ReaderBuilders.fromField;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithOptionalMeaningfulGoalsValuesFromMetrikaTypeSupport extends
        AbstractCampaignRepositoryTypeSupport<CampaignWithOptionalMeaningfulGoalsValuesFromMetrika> {

    private static final JooqReader<CampaignWithOptionalMeaningfulGoalsValuesFromMetrika> READER = createReader();

    @Autowired
    public CampaignWithOptionalMeaningfulGoalsValuesFromMetrikaTypeSupport(DslContextProvider dslContextProvider) {
        super(dslContextProvider);
    }

    @Override
    public Class<CampaignWithOptionalMeaningfulGoalsValuesFromMetrika> getTypeClass() {
        return CampaignWithOptionalMeaningfulGoalsValuesFromMetrika.class;
    }

    @Override
    public Collection<Field<?>> getFields() {
        return READER.getFieldsToRead();
    }

    @Override
    public void fillFromRecord(CampaignWithOptionalMeaningfulGoalsValuesFromMetrika campaign, Record record) {
        READER.fromDb(record, campaign);
    }

    private static JooqReader<CampaignWithOptionalMeaningfulGoalsValuesFromMetrika> createReader() {
        return JooqReaderBuilder.<CampaignWithOptionalMeaningfulGoalsValuesFromMetrika>builder()
                .readProperty(CampaignWithOptionalMeaningfulGoalsValuesFromMetrika.IS_MEANINGFUL_GOALS_VALUES_FROM_METRIKA_ENABLED,
                        fromField(CAMPAIGNS.OPTS).by(CampaignConverter::isMeaningfulGoalsValuesFromMetrika))
                .build();
    }
}
