package ru.yandex.direct.core.entity.campaign.repository.type;

import java.util.Collection;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.Field;
import org.jooq.Record;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.converter.CampaignConverter;
import ru.yandex.direct.core.entity.campaign.model.CampaignWithOptionalRequireFiltrationByDontShowDomains;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.jooqmapper.read.JooqReader;
import ru.yandex.direct.jooqmapper.read.JooqReaderBuilder;

import static ru.yandex.direct.dbschema.ppc.tables.Campaigns.CAMPAIGNS;
import static ru.yandex.direct.jooqmapper.read.ReaderBuilders.fromField;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithOptionalRequireFiltrationByDontShowDomainsTypeSupport extends
        AbstractCampaignRepositoryTypeSupport<CampaignWithOptionalRequireFiltrationByDontShowDomains> {

    private static final JooqReader<CampaignWithOptionalRequireFiltrationByDontShowDomains> READER = createReader();

    @Autowired
    public CampaignWithOptionalRequireFiltrationByDontShowDomainsTypeSupport(DslContextProvider dslContextProvider) {
        super(dslContextProvider);
    }

    @Override
    public Class<CampaignWithOptionalRequireFiltrationByDontShowDomains> getTypeClass() {
        return CampaignWithOptionalRequireFiltrationByDontShowDomains.class;
    }

    @Override
    public Collection<Field<?>> getFields() {
        return READER.getFieldsToRead();
    }

    @Override
    public void fillFromRecord(CampaignWithOptionalRequireFiltrationByDontShowDomains campaign, Record record) {
        READER.fromDb(record, campaign);
    }

    private static JooqReader<CampaignWithOptionalRequireFiltrationByDontShowDomains> createReader() {
        return JooqReaderBuilder.<CampaignWithOptionalRequireFiltrationByDontShowDomains>builder()
                .readProperty(CampaignWithOptionalRequireFiltrationByDontShowDomains.REQUIRE_FILTRATION_BY_DONT_SHOW_DOMAINS,
                        fromField(CAMPAIGNS.OPTS).by(CampaignConverter::isRequireFiltrationByDontShowDomains))
                .build();
    }
}
