package ru.yandex.direct.core.entity.campaign.repository.type;

import java.util.Collection;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.Field;
import org.jooq.Record;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.converter.CampaignConverter;
import ru.yandex.direct.core.entity.campaign.model.CampaignWithOrderPhraseLengthPrecedence;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.jooqmapper.read.JooqReader;
import ru.yandex.direct.jooqmapper.read.JooqReaderBuilder;

import static ru.yandex.direct.dbschema.ppc.tables.Campaigns.CAMPAIGNS;
import static ru.yandex.direct.jooqmapper.read.ReaderBuilders.fromField;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithOrderPhraseLengthPrecedenceTypeSupport extends AbstractCampaignRepositoryTypeSupport<CampaignWithOrderPhraseLengthPrecedence> {
    private static final JooqReader<CampaignWithOrderPhraseLengthPrecedence> READER = createReader();

    @Autowired
    public CampaignWithOrderPhraseLengthPrecedenceTypeSupport(DslContextProvider dslContextProvider) {
        super(dslContextProvider);
    }

    @Override
    public Collection<Field<?>> getFields() {
        return READER.getFieldsToRead();
    }

    @Override
    public <M extends CampaignWithOrderPhraseLengthPrecedence> void fillFromRecord(M campaign, Record record) {
        READER.fromDb(record, campaign);
    }

    @Override
    public Class<CampaignWithOrderPhraseLengthPrecedence> getTypeClass() {
        return CampaignWithOrderPhraseLengthPrecedence.class;
    }

    private static JooqReader<CampaignWithOrderPhraseLengthPrecedence> createReader() {
        return JooqReaderBuilder.<CampaignWithOrderPhraseLengthPrecedence>builder()
                .readProperty(CampaignWithOrderPhraseLengthPrecedence.IS_ORDER_PHRASE_LENGTH_PRECEDENCE_ENABLED,
                        fromField(CAMPAIGNS.OPTS).by(CampaignConverter::isOrderPhraseLengthPrecedenceEnabled))
                .build();
    }
}
